/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql;

import cn.schoolwow.quickdao.dao.ConnectionExecutor;
import cn.schoolwow.quickdao.dao.ConnectionExecutorImpl;
import cn.schoolwow.quickdao.dao.sql.DatabaseDAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.SFunction;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.ExistAnyDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.ExistDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.FetchListDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.FetchNullDatabaseStatement;
import cn.schoolwow.quickdao.util.LambdaUtils;
import cn.schoolwow.quickdao.util.ResponseUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AbstractDatabaseDAO
implements DatabaseDAO {
    public ConnectionExecutor connectionExecutor;
    protected QuickDAOConfig quickDAOConfig;

    public AbstractDatabaseDAO(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
        this.connectionExecutor = new ConnectionExecutorImpl(quickDAOConfig);
    }

    @Override
    public boolean exist(Object instance) {
        if (null == instance) {
            return false;
        }
        int count = new ExistDatabaseStatement(instance, this.quickDAOConfig).getCount();
        return count > 0;
    }

    @Override
    public boolean existAny(Object ... instances) {
        int count = new ExistAnyDatabaseStatement(instances, this.quickDAOConfig).getCount();
        return count > 0;
    }

    @Override
    public boolean existAll(Object ... instances) {
        int count = new ExistAnyDatabaseStatement(instances, this.quickDAOConfig).getCount();
        return count == instances.length;
    }

    @Override
    public boolean existAny(Collection instances) {
        return this.existAny(instances.toArray());
    }

    @Override
    public boolean existAll(Collection instances) {
        return this.existAll(instances.toArray());
    }

    @Override
    public <T> T fetch(Class<T> clazz, long id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.fetch(clazz, entity.id.column, (Object)id);
    }

    @Override
    public <T> T fetch(Class<T> clazz, String field, Object value) {
        List<T> list = this.fetchList(clazz, field, value);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, String fieldName, Object value) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName());
        }
        Property property = entity.getPropertyByFieldName(fieldName);
        if (null == property) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName() + ",\u5b57\u6bb5:" + fieldName);
        }
        JSONArray array = this.fetchList(entity, property.column, value);
        return array.toJavaList(clazz);
    }

    @Override
    public <T> T fetch(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String convertField = LambdaUtils.resolveLambdaProperty(field);
        return this.fetch(clazz, convertField, value);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String convertField = LambdaUtils.resolveLambdaProperty(field);
        return this.fetchList(clazz, convertField, value);
    }

    @Override
    public JSONObject fetch(String tableName, String columnName, Object value) {
        JSONArray array = this.fetchList(tableName, columnName, value);
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray fetchList(String tableName, String columnName, Object value) {
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == entity) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        JSONArray array = this.fetchList(entity, columnName, value);
        return array;
    }

    @Override
    public JSONArray rawSelect(String selectSQL, Object ... parameters) {
        JSONArray array = new JSONArray();
        this.connectionExecutor.name("\u7528\u6237\u81ea\u5b9a\u4e49").sql(selectSQL).parameters(Arrays.asList(parameters)).executeQuery(resultSet -> ResponseUtil.getRawSelectArray(resultSet, array));
        return array;
    }

    @Override
    public int delete(Class clazz, long id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String field, Object value) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        String columnName = entity.getColumnNameByFieldName(field);
        return this.delete(entity.tableName, columnName, value);
    }

    @Override
    public int delete(String tableName, String columnName, Object value) {
        int effect = this.rawUpdate("delete from " + this.quickDAOConfig.databaseProvider.escape(tableName) + " where " + this.quickDAOConfig.databaseProvider.escape(columnName) + " = ?", value);
        return effect;
    }

    @Override
    public <T> int delete(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String fieldName = LambdaUtils.resolveLambdaProperty(field);
        return this.delete(clazz, fieldName, value);
    }

    @Override
    public int clear(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        int effect = this.rawUpdate("delete from " + this.quickDAOConfig.databaseProvider.escape(entity.tableName), new Object[0]);
        return effect;
    }

    @Override
    public int rawUpdate(String updateSQL, Object ... parameters) {
        int effect = this.connectionExecutor.name("\u81ea\u5b9a\u4e49\u66f4\u65b0").sql(updateSQL).parameters(Arrays.asList(parameters)).executeUpdate();
        return effect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rawUpdateBatch(String updateSQL, List<List<Object>> parameterBatchList) {
        this.connectionExecutor.name("\u81ea\u5b9a\u4e49\u6279\u5904\u7406\u66f4\u65b0").sql(updateSQL).startBatch();
        int perBatchCount = this.quickDAOConfig.databaseOption.perBatchCount;
        int effect = 0;
        try {
            for (int i = 0; i < parameterBatchList.size(); i += perBatchCount) {
                int end = Math.min(i + perBatchCount, parameterBatchList.size());
                for (int j = i; j < end; ++j) {
                    List<Object> parameters = parameterBatchList.get(j);
                    this.connectionExecutor.batchParameters(parameters);
                }
                effect += this.connectionExecutor.executeBatch();
                this.connectionExecutor.clearBatch();
            }
        }
        finally {
            this.connectionExecutor.closeBatch();
        }
        return effect;
    }

    private JSONArray fetchList(Entity entity, String columnName, Object value) {
        AbstractDQLDatabaseStatement databaseStatement = null == value ? new FetchNullDatabaseStatement(entity, columnName, this.quickDAOConfig) : new FetchListDatabaseStatement(entity, columnName, value, this.quickDAOConfig);
        JSONArray array = databaseStatement.getArray();
        return array;
    }
}

