/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.transaction;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class QuickDAOPlatformTransactionManager
extends AbstractPlatformTransactionManager {
    private Logger logger = LoggerFactory.getLogger(QuickDAOPlatformTransactionManager.class);
    private DAO dao;

    public QuickDAOPlatformTransactionManager(DAO dao) {
        this.dao = dao;
    }

    protected Object doGetTransaction() throws TransactionException {
        Transaction transaction = this.dao.startTransaction();
        this.dao.getQuickDAOConfig().transactionThreadLocal.set(transaction);
        this.logger.trace("\u83b7\u53d6\u4e8b\u52a1\u5bf9\u8c61! \u4e8b\u52a1\u5bf9\u8c61:{},DAO:{}", (Object)transaction, (Object)this.dao);
        return transaction;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        Transaction transactionDAO = (Transaction)transaction;
        this.logger.trace("\u5f00\u542f\u4e8b\u52a1!\u4e8b\u52a1\u9694\u79bb\u7ea7\u522b:{},\u4e8b\u52a1:{},DAO:{}", new Object[]{definition.getIsolationLevel(), transaction, this.dao});
        int isolationLevel = definition.getIsolationLevel();
        switch (isolationLevel) {
            case -1: {
                break;
            }
            case 1: {
                transactionDAO.setTransactionIsolation(1);
                break;
            }
            case 2: {
                transactionDAO.setTransactionIsolation(2);
                break;
            }
            case 4: {
                transactionDAO.setTransactionIsolation(4);
                break;
            }
            case 8: {
                transactionDAO.setTransactionIsolation(8);
            }
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        Transaction transaction = (Transaction)status.getTransaction();
        this.logger.trace("\u63d0\u4ea4\u4e8b\u52a1,\u4e8b\u52a1\u5bf9\u8c61:{},DAO:{}", (Object)transaction, (Object)this.dao);
        transaction.commit();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        Transaction transaction = (Transaction)status.getTransaction();
        this.logger.trace("\u56de\u9000\u4e8b\u52a1,\u4e8b\u52a1\u5bf9\u8c61:{},DAO:{}", (Object)transaction, (Object)this.dao);
        transaction.rollback();
    }
}

