/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.entity;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.entity.TableDefiner;
import cn.schoolwow.quickdao.entity.TablePropertyDefiner;

public class TablePropertyDefinerImpl
implements TablePropertyDefiner {
    private Property property;
    private TableDefiner tableDefiner;

    public TablePropertyDefinerImpl(Property property, TableDefiner tableDefiner) {
        this.property = property;
        this.tableDefiner = tableDefiner;
    }

    @Override
    public TablePropertyDefiner id(boolean id) {
        this.property.id = true;
        this.property.strategy = IdStrategy.AutoIncrement;
        return this;
    }

    @Override
    public TablePropertyDefiner strategy(IdStrategy idStrategy) {
        this.property.strategy = idStrategy;
        return this;
    }

    @Override
    public TablePropertyDefiner columnType(String columnType) {
        this.property.columnType = columnType;
        return this;
    }

    @Override
    public TablePropertyDefiner columnName(String columnName) {
        this.property.column = columnName;
        return this;
    }

    @Override
    public TablePropertyDefiner comment(String comment) {
        this.property.comment = comment;
        return this;
    }

    @Override
    public TablePropertyDefiner notNull(boolean notNull) {
        this.property.notNull = notNull;
        return this;
    }

    @Override
    public TablePropertyDefiner primaryKey(boolean primaryKey) {
        this.property.id = true;
        return this;
    }

    @Override
    public TablePropertyDefiner check(String check) {
        if (null != check) {
            this.property.check = check;
            if (!this.property.check.isEmpty() && !this.property.check.contains("(")) {
                this.property.check = "(" + this.property.check + ")";
            }
            this.property.check = this.property.check.replace("#{" + this.property.name + "}", this.property.column);
        }
        return this;
    }

    @Override
    public TablePropertyDefiner defaultValue(String defaultValue) {
        this.property.defaultValue = defaultValue;
        return this;
    }

    @Override
    public TablePropertyDefiner index(IndexType indexType, String indexName, String using, String comment) {
        IndexField indexField = new IndexField();
        indexField.tableName = this.property.entity.tableName;
        indexField.indexType = indexType;
        indexField.indexName = null == indexName || indexName.isEmpty() ? indexField.tableName + "_" + indexType.name().toLowerCase() + "_" + this.property.column : indexName;
        indexField.using = using;
        indexField.comment = comment;
        indexField.columns.add(this.property.column);
        this.property.entity.indexFieldList.add(indexField);
        return this;
    }

    @Override
    public TableDefiner done() {
        return this.tableDefiner;
    }
}

