/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.AbstractDMLDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.SelectCountByUniqueKeyDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.SelectExistsValueBySingleFieldDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class AbstractDMLInstanceDatabaseStatement
extends AbstractDMLDatabaseStatement {
    public AbstractDMLInstanceDatabaseStatement(ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
    }

    protected void distinguishInstancesBySingleField(Object[] instances, String tableName, Property property, List insertInstances, List updateInstances) {
        ArrayList<Object> parameters = new ArrayList<Object>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            Object value = ParametersUtil.getFieldValueFromInstance(instances[i], property.name);
            parameters.add(value);
        }
        SelectExistsValueBySingleFieldDatabaseStatement selectExistsValueBySingleFieldDatabaseStatement = new SelectExistsValueBySingleFieldDatabaseStatement(tableName, property.column, parameters, this.quickDAOConfig);
        List<String> existValues = selectExistsValueBySingleFieldDatabaseStatement.getSingleColumnList();
        for (int i = 0; i < instances.length; ++i) {
            Object value = ParametersUtil.getFieldValueFromInstance(instances[i], property.name);
            if (null != insertInstances && !existValues.contains(value.toString())) {
                insertInstances.add(instances[i]);
                continue;
            }
            if (null == updateInstances) continue;
            updateInstances.add(instances[i]);
        }
    }

    protected void distinguishInstancesByMultipleField(Object[] instances, List insertInstances, List updateInstances) {
        for (int i = 0; i < instances.length; ++i) {
            Object instance = instances[i];
            SelectCountByUniqueKeyDatabaseStatement selectCountByUniqueKeyDatabaseStatement = new SelectCountByUniqueKeyDatabaseStatement(instance, this.quickDAOConfig);
            int count = selectCountByUniqueKeyDatabaseStatement.getCount();
            if (null != insertInstances && count <= 0) {
                insertInstances.add(instance);
                continue;
            }
            if (null == updateInstances) continue;
            updateInstances.add(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeBatch(Object[] instances) {
        int effect = 0;
        this.connectionExecutor.name(this.name()).sql(this.getStatement()).startBatch();
        try {
            for (int i = 0; i < instances.length; i += this.option.perBatchCount) {
                int end = Math.min(i + this.option.perBatchCount, instances.length);
                this.logger.trace("\u6279\u5904\u7406,\u603b\u4e2a\u6570:{},\u5f53\u524d\u8303\u56f4:{}-{}", new Object[]{instances.length, i, end});
                int j = i;
                while (j < end) {
                    this.index = j++;
                    List parameters = this.getParameters();
                    this.connectionExecutor.batchParameters(parameters);
                }
                effect += this.connectionExecutor.executeBatch();
                this.connectionExecutor.clearBatch();
            }
        }
        finally {
            this.connectionExecutor.closeBatch();
        }
        return effect;
    }

    protected List<Property> getPartColumnPropertyList(Entity entity) {
        List<Property> propertyList = null;
        if (this.option.partColumnSet.isEmpty()) {
            propertyList = entity.properties;
        } else {
            propertyList = new ArrayList<Property>();
            for (Property property : entity.properties) {
                if (!property.createdAt && !property.updateAt && !this.option.partColumnSet.contains(property.column) && !this.option.partColumnSet.contains(property.name)) continue;
                propertyList.add(property);
            }
        }
        if (propertyList.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5partColumn\u65b9\u6cd5\u53c2\u6570\u662f\u5426\u5408\u6cd5!\u6570\u636e\u5e93\u8868[" + entity.tableName + "]\u4e0d\u5b58\u5728\u6307\u5b9a\u5b57\u6bb5" + this.option.partColumnSet);
        }
        return propertyList;
    }
}

