/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteInstanceBySingleFieldDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    private Object[] instances;
    private Property property;

    public DeleteInstanceBySingleFieldDatabaseStatement(Object[] instances, Property property, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
        this.property = property;
    }

    @Override
    public String getStatement() {
        StringBuilder builder = new StringBuilder();
        builder.append("delete from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " where " + this.property.column + " in (");
        for (int i = 0; i < this.instances.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public List getParameters() {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (int i = 0; i < this.instances.length; ++i) {
            Object value = ParametersUtil.getFieldValueFromInstance(this.instances[i], this.property.name);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636e\u5355\u4e2a\u552f\u4e00\u6027\u7ea6\u675f\u5b57\u6bb5\u5220\u9664\u8bb0\u5f55";
    }
}

