/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.json;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.json.AbstractDMLJSONDatabaseStatement;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class InsertJSONArrayDatabaseStatement
extends AbstractDMLJSONDatabaseStatement {
    private String tableName;
    private JSONArray instances;
    private List<String> columns;

    public InsertJSONArrayDatabaseStatement(String tableName, JSONArray instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.tableName = tableName;
        this.instances = instances;
        this.columns = this.getPartColumns(tableName);
    }

    @Override
    public int executeUpdate() {
        int effect = 0;
        if (this.option.batch) {
            effect = this.executeBatch(this.instances);
        } else {
            int i = 0;
            while (i < this.instances.size()) {
                this.index = i++;
                effect += super.executeUpdate();
                JSONObject instance = this.instances.getJSONObject(this.index);
                instance.put("generateKeys", (Object)this.connectionExecutor.getGeneratedKeys());
            }
        }
        return effect;
    }

    @Override
    public String getStatement() {
        StringBuilder builder = new StringBuilder("insert into " + this.quickDAOConfig.databaseProvider.escape(this.tableName) + "(");
        for (String column : this.columns) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") values(");
        for (String column : this.columns) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        String sql = builder.toString();
        return sql;
    }

    @Override
    public List getParameters() {
        JSONObject instance = this.instances.getJSONObject(this.index);
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (String column : this.columns) {
            Object value = instance.get((Object)column);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "JSONArray\u63d2\u5165";
    }
}

