/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.json;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.AbstractDMLDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.AbstractDMLJSONDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.InsertJSONArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.UpdateJSONArrayDatabaseStatement;
import com.alibaba.fastjson.JSONArray;

public class SaveJSONArrayDatabaseStatement
extends AbstractDMLJSONDatabaseStatement {
    private String tableName;
    private JSONArray instances;

    public SaveJSONArrayDatabaseStatement(String tableName, JSONArray instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.tableName = tableName;
        this.instances = instances;
    }

    @Override
    public int executeUpdate() {
        JSONArray insertArray = new JSONArray();
        JSONArray updateArray = new JSONArray();
        if (this.option.uniqueFieldNames.size() == 1) {
            String uniqueFieldName = this.option.uniqueFieldNames.iterator().next();
            this.distinguishJSONArrayBySingleField(this.tableName, this.instances, uniqueFieldName, insertArray, updateArray);
        } else {
            this.distinguishJSONArrayByMultipleField(this.tableName, this.instances, insertArray, updateArray);
        }
        int effect = 0;
        if (!insertArray.isEmpty()) {
            InsertJSONArrayDatabaseStatement insertJSONArrayDatabaseStatement = new InsertJSONArrayDatabaseStatement(this.tableName, insertArray, this.option, this.quickDAOConfig);
            effect += ((AbstractDMLDatabaseStatement)insertJSONArrayDatabaseStatement).executeUpdate();
        }
        if (!updateArray.isEmpty()) {
            UpdateJSONArrayDatabaseStatement updateJSONArrayDatabaseStatement = new UpdateJSONArrayDatabaseStatement(this.tableName, this.instances, this.option, this.quickDAOConfig);
            effect += updateJSONArrayDatabaseStatement.executeUpdate();
        }
        return effect;
    }

    @Override
    public String name() {
        return "SaveJSONArray\u63d2\u5165";
    }
}

