/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.json;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.json.AbstractDMLJSONDatabaseStatement;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class UpdateJSONObjectDatabaseStatement
extends AbstractDMLJSONDatabaseStatement {
    private String tableName;
    protected JSONObject instance;
    private List<String> columns;

    public UpdateJSONObjectDatabaseStatement(String tableName, JSONObject instance, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.tableName = tableName;
        this.instance = instance;
        this.columns = this.getPartColumns(tableName);
    }

    @Override
    public String getStatement() {
        StringBuilder builder = new StringBuilder("update " + this.quickDAOConfig.databaseProvider.escape(this.tableName) + " set ");
        for (String column : this.columns) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(column) + " = ?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" where");
        for (String uniqueFieldName : this.option.uniqueFieldNames) {
            builder.append(" " + uniqueFieldName + " = ? and");
        }
        builder.delete(builder.length() - 4, builder.length());
        String sql = builder.toString();
        return sql;
    }

    @Override
    public List getParameters() {
        Object value;
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (String column : this.columns) {
            value = this.instance.get((Object)column);
            parameterList.add(value);
        }
        for (String uniqueFieldName : this.option.uniqueFieldNames) {
            value = this.instance.get((Object)uniqueFieldName);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "JSONObject\u66f4\u65b0";
    }
}

