/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql;

import cn.schoolwow.quickdao.dao.ConnectionExecutor;
import cn.schoolwow.quickdao.dao.ConnectionExecutorImpl;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.statement.AbstractDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.DQLDatabaseStatement;
import cn.schoolwow.quickdao.util.ResponseUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDQLDatabaseStatement
extends AbstractDatabaseStatement
implements DQLDatabaseStatement {
    protected ConnectionExecutor connectionExecutor;

    public AbstractDQLDatabaseStatement(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.connectionExecutor = new ConnectionExecutorImpl(quickDAOConfig);
    }

    @Override
    public int getCount() {
        int[] count = new int[1];
        this.connectionExecutor.returnGeneratedKeys(false).name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeQuery(resultSet -> {
            if (resultSet.next()) {
                count[0] = resultSet.getInt(1);
            }
        });
        return count[0];
    }

    @Override
    public List<String> getSingleColumnList() {
        ArrayList<String> parameters = new ArrayList<String>();
        this.connectionExecutor.returnGeneratedKeys(false).name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeQuery(resultSet -> {
            while (resultSet.next()) {
                parameters.add(resultSet.getString(1));
            }
        });
        return parameters;
    }

    @Override
    public JSONArray getArray() {
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u652f\u6301\u6267\u884cgetArray\u65b9\u6cd5");
    }

    @Override
    public int executeUpdate() {
        int effect = this.connectionExecutor.returnGeneratedKeys(false).name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeUpdate();
        return effect;
    }

    protected JSONArray getArray(Entity entity, String tableAliasName) {
        JSONArray array = new JSONArray();
        this.connectionExecutor.returnGeneratedKeys(false).name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeQuery(resultSet -> {
            while (resultSet.next()) {
                JSONObject object = ResponseUtil.getObject(entity, null, tableAliasName, resultSet, this.quickDAOConfig.databaseProvider);
                array.add((Object)object);
            }
        });
        return array;
    }

    protected String columns(Entity entity, String tableAlias) {
        StringBuilder builder = new StringBuilder();
        for (Property property : entity.properties) {
            builder.append(tableAlias + "." + this.quickDAOConfig.databaseProvider.escape(property.column) + " as " + tableAlias + "_" + property.column + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    protected String columnExcludes(Entity entity, String tableAlias, List<String> excludeColumnList) {
        StringBuilder builder = new StringBuilder();
        for (Property property : entity.properties) {
            if (excludeColumnList.contains(property.column) || excludeColumnList.contains(property.name)) continue;
            builder.append(tableAlias + "." + this.quickDAOConfig.databaseProvider.escape(property.column) + " as " + tableAlias + "_" + property.column + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

