/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.List;

public class SelectCountBySingleFieldDatabaseStatement
extends AbstractDQLDatabaseStatement {
    private Object[] instances;
    private Property property;
    private Entity entity;

    public SelectCountBySingleFieldDatabaseStatement(Object[] instances, Property property, QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.instances = instances;
        this.property = property;
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
    }

    @Override
    public String getStatement() {
        StringBuilder builder = new StringBuilder("select count(1) from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " where " + this.property.column + " in (");
        for (int i = 0; i < this.instances.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        String sql = builder.toString();
        return sql;
    }

    @Override
    public List getParameters() {
        List parameterList = ParametersUtil.getFieldValueListFromInstance(this.instances, this.property.name);
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636e\u5355\u5217\u67e5\u8be2\u4e2a\u6570";
    }
}

