/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class SelectCountByUniqueKeyDatabaseStatement
extends AbstractDQLDatabaseStatement {
    private Entity entity;
    private Object instance;

    public SelectCountByUniqueKeyDatabaseStatement(Object instance, QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        this.instance = instance;
    }

    @Override
    public String getStatement() {
        String key = "selectCountByUniqueKey_" + this.entity.tableName + "_" + this.quickDAOConfig.databaseProvider.name();
        if (!this.quickDAOConfig.statementCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            builder.append("select count(1) from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " where ");
            for (Property property : this.entity.uniqueProperties) {
                builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + "= " + (null == property.function ? "?" : property.function) + " and ");
            }
            builder.delete(builder.length() - 5, builder.length());
            this.quickDAOConfig.statementCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.statementCache.get(key);
        return sql;
    }

    @Override
    public List getParameters() {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (Property property : this.entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(this.instance, property.name);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636e\u5b9e\u4f53\u7c7b\u552f\u4e00\u6027\u7ea6\u675f\u67e5\u8be2\u4e2a\u6570";
    }
}

