/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.response;

import cn.schoolwow.quickdao.domain.internal.Query;
import cn.schoolwow.quickdao.domain.internal.SubQuery;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractDQLResponseDatabaseStatement
extends AbstractDQLDatabaseStatement {
    protected Query query;
    protected StringBuilder builder = new StringBuilder();
    protected List parameters = new ArrayList();

    public AbstractDQLResponseDatabaseStatement(Query query) {
        super(query.quickDAOConfig);
        this.query = query;
    }

    protected void addJoinTableStatement() {
        for (SubQuery subQuery : this.query.subQueryList) {
            this.builder.append(" " + subQuery.join + " ");
            if (null == subQuery.subQuerySQLBuilder) {
                this.builder.append(this.query.quickDAOConfig.databaseProvider.escape(subQuery.entity.tableName));
            } else {
                this.builder.append("(" + subQuery.subQuerySQLBuilder.toString() + ")");
            }
            this.builder.append(" " + subQuery.tableAliasName);
            if (null == subQuery.primaryField || null == subQuery.joinTableField) continue;
            this.builder.append(" on ");
            if (subQuery.parentSubQuery == null) {
                this.builder.append(this.query.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(subQuery.primaryField) + " = " + subQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(subQuery.joinTableField) + " ");
            } else {
                this.builder.append(subQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(subQuery.joinTableField) + " = " + subQuery.parentSubQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(subQuery.primaryField) + " ");
            }
            if (subQuery.onConditionMap.isEmpty()) continue;
            Set<Map.Entry<String, String>> entrySet = subQuery.onConditionMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.builder.append(" and ");
                if (subQuery.parentSubQuery == null) {
                    this.builder.append(this.query.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(entry.getKey()) + " = " + subQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(entry.getValue()) + " ");
                    continue;
                }
                this.builder.append(subQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(entry.getValue()) + " = " + subQuery.parentSubQuery.tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(entry.getKey()) + " ");
            }
        }
    }

    protected void addArraySQLParameters(Query query, Query mainQuery) {
        for (Query selectQuery : query.selectQueryList) {
            this.addArraySQLParameters(selectQuery, mainQuery);
        }
        if (null != query.fromQuery) {
            this.addArraySQLParameters(query.fromQuery, mainQuery);
        }
        for (SubQuery subQuery : query.subQueryList) {
            if (null == subQuery.subQuery) continue;
            this.addArraySQLParameters(subQuery.subQuery, mainQuery);
        }
        this.addMainTableParameters(query);
    }

    protected void addMainTableParameters(Query query) {
        for (Object parameter : query.parameterList) {
            this.parameters.add(parameter);
        }
        for (Object parameter : query.havingParameterList) {
            this.parameters.add(parameter);
        }
    }
}

