/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.response;

import cn.schoolwow.quickdao.dao.dql.condition.AbstractCondition;
import cn.schoolwow.quickdao.domain.internal.Query;
import cn.schoolwow.quickdao.domain.internal.SubQuery;
import cn.schoolwow.quickdao.statement.dql.response.AbstractDQLResponseDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.response.ResponseCountInternalDatabaseStatement;
import cn.schoolwow.quickdao.util.ResponseUtil;
import com.alibaba.fastjson.JSONArray;
import java.util.List;

public class GetResponseArrayDatabaseStatement
extends AbstractDQLResponseDatabaseStatement {
    public GetResponseArrayDatabaseStatement(Query query) {
        super(query);
    }

    public <E> List<E> getSingleColumnList(Class<E> clazz) {
        int count = new ResponseCountInternalDatabaseStatement(this.query).getCount();
        JSONArray array = new JSONArray(count);
        this.connectionExecutor.name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeQuery(resultSet -> {
            while (resultSet.next()) {
                array.add(resultSet.getObject(1));
            }
        });
        return array.toJavaList(clazz);
    }

    @Override
    public JSONArray getArray() {
        int count = new ResponseCountInternalDatabaseStatement(this.query).getCount();
        JSONArray array = new JSONArray(count);
        this.connectionExecutor.name(this.name()).sql(this.getStatement()).parameters(this.getParameters()).executeQuery(resultSet -> ResponseUtil.getResponseArray(resultSet, this.query, array));
        return array;
    }

    @Override
    public String getStatement() {
        if (this.query.unionList.isEmpty()) {
            this.getUnionArraySQL(this.query);
            this.builder.append(" " + this.query.orderBy + " " + this.query.limit);
        } else {
            this.getUnionArraySQL(this.query);
            for (AbstractCondition abstractCondition : this.query.unionList) {
                switch (abstractCondition.query.unionType) {
                    case Union: {
                        this.builder.append(" union ");
                        break;
                    }
                    case UnionAll: {
                        this.builder.append(" union all ");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684Union\u7c7b\u578b!\u5f53\u524d\u7c7b\u578b:" + (Object)((Object)abstractCondition.query.unionType));
                    }
                }
                this.getUnionArraySQL(abstractCondition.query);
            }
            this.builder.append(" " + this.query.orderBy + " " + this.query.limit);
        }
        String sql = this.builder.toString();
        return sql;
    }

    @Override
    public List getParameters() {
        this.addArraySQLParameters(this.query, this.query);
        for (AbstractCondition abstractCondition : this.query.unionList) {
            Query unionQuery = abstractCondition.query;
            for (SubQuery subQuery : unionQuery.subQueryList) {
                if (null == subQuery.subQuery) continue;
                this.addMainTableParameters(subQuery.subQuery);
            }
            this.addMainTableParameters(unionQuery);
            for (SubQuery parameter : unionQuery.havingParameterList) {
                this.parameters.add(parameter);
            }
        }
        return this.parameters;
    }

    @Override
    public String name() {
        return "\u6267\u884c\u590d\u6742\u67e5\u8be2";
    }

    private void getUnionArraySQL(Query query) {
        this.builder.append("select " + query.distinct + " ");
        if (!query.column.isEmpty()) {
            this.builder.append(query.column);
        } else {
            this.builder.append(this.columns(query.entity, query.tableAliasName));
        }
        if (query.compositField) {
            for (SubQuery subQuery : query.subQueryList) {
                if (subQuery.subCondition.excludeColumnList.isEmpty()) {
                    this.builder.append("," + this.columns(subQuery.entity, subQuery.tableAliasName));
                    continue;
                }
                this.builder.append("," + this.columnExcludes(subQuery.entity, subQuery.tableAliasName, subQuery.subCondition.excludeColumnList));
            }
        }
        this.builder.append(" from");
        if (this.quickDAOConfig.databaseOption.virtualTableNameList.contains(query.entity.tableName)) {
            this.builder.append(" " + query.entity.tableName);
        } else if (query.entity.tableName.startsWith("(")) {
            this.builder.append(" " + query.entity.tableName + " " + query.tableAliasName);
        } else {
            this.builder.append(" " + query.quickDAOConfig.databaseProvider.escape(query.entity.tableName) + " " + query.tableAliasName);
        }
        this.addJoinTableStatement();
        this.builder.append(" " + query.where + " " + query.groupBy + " " + query.having);
    }
}

