/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.annotation.ColumnName;
import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.CompositeIndex;
import cn.schoolwow.quickdao.annotation.CompositeIndexes;
import cn.schoolwow.quickdao.annotation.Constraint;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.Index;
import cn.schoolwow.quickdao.annotation.Indexes;
import cn.schoolwow.quickdao.annotation.TableField;
import cn.schoolwow.quickdao.annotation.TableName;
import cn.schoolwow.quickdao.annotation.UniqueField;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.internal.EntityOption;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUtil {
    private static Logger logger = LoggerFactory.getLogger(EntityUtil.class);

    public static Map<String, Entity> getEntityMap(EntityOption entityOption) {
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        EntityUtil.getPackageClass(entityMap, entityOption);
        EntityUtil.getEntityClassMap(entityMap, entityOption.entityClassMap);
        Iterator entityIterator = entityMap.values().iterator();
        Map<String, String> typeFieldMapping = entityOption.databaseProvider.getTypeFieldMapping();
        while (entityIterator.hasNext()) {
            Entity entity = (Entity)entityIterator.next();
            ArrayList<Property> propertyList = new ArrayList<Property>();
            Field[] fields = EntityUtil.getAllFields(entity.clazz, entityOption);
            for (Field field : fields) {
                if (EntityUtil.isCompositProperty(field.getType(), entityOption)) {
                    if (!entity.compositFieldMap.containsKey(field.getType().getName())) {
                        entity.compositFieldMap.put(field.getType().getName(), new ArrayList());
                    }
                    entity.compositFieldMap.get(field.getType().getName()).add(field.getName());
                    continue;
                }
                Property property = EntityUtil.getProperty(field, entity, typeFieldMapping, entityOption);
                propertyList.add(property);
            }
            entity.properties = propertyList;
            EntityUtil.getEntity(entity);
            if (!"H2".equalsIgnoreCase(entityOption.databaseProvider.name())) continue;
            entity.tableName = entity.tableName.toUpperCase();
            for (Property property : entity.properties) {
                property.column = property.column.toUpperCase();
            }
        }
        return entityMap;
    }

    private static void getPackageClass(Map<String, Entity> entityMap, EntityOption entityOption) {
        for (String packageName : entityOption.packageNameMap.keySet()) {
            List<Class> packageClassList = EntityUtil.scanPackageClassList(packageName, entityOption);
            for (Class packageClass : packageClassList) {
                Entity entity = new Entity();
                if (packageClass.getDeclaredAnnotation(TableName.class) != null) {
                    entity.tableName = packageClass.getDeclaredAnnotation(TableName.class).value();
                } else if (packageName.length() + packageClass.getSimpleName().length() + 1 == packageClass.getName().length()) {
                    entity.tableName = entityOption.packageNameMap.get(packageName) + StringUtil.camel2Underline(packageClass.getSimpleName());
                } else {
                    String prefix = packageClass.getName().substring(packageName.length() + 1, packageClass.getName().lastIndexOf(".")).replace(".", "_");
                    entity.tableName = entityOption.packageNameMap.get(packageName) + prefix + "@" + StringUtil.camel2Underline(packageClass.getSimpleName());
                }
                entity.clazz = packageClass;
                entityMap.put(packageClass.getName(), entity);
            }
        }
    }

    private static void getEntityClassMap(Map<String, Entity> entityMap, Map<Class, String> entityClassMap) {
        for (Class entityClass : entityClassMap.keySet()) {
            Entity entity = new Entity();
            entity.tableName = entityClass.getDeclaredAnnotation(TableName.class) != null ? entityClass.getDeclaredAnnotation(TableName.class).value() : (entityClassMap.get(entityClass).isEmpty() ? StringUtil.camel2Underline(entityClass.getSimpleName()) : entityClassMap.get(entityClass) + "@" + StringUtil.camel2Underline(entityClass.getSimpleName()));
            entity.clazz = entityClass;
            entityMap.put(entityClass.getName(), entity);
        }
    }

    private static Property getProperty(Field field, Entity entity, Map<String, String> typeFieldMapping, EntityOption entityOption) {
        Indexes indexes;
        TableField tableField;
        Id id;
        Constraint constraint;
        String lengthString;
        Property property = new Property();
        property.column = null != field.getAnnotation(ColumnName.class) ? field.getAnnotation(ColumnName.class).value() : StringUtil.camel2Underline(field.getName());
        property.columnLabel = property.name = field.getName();
        property.clazz = field.getType();
        property.className = field.getType().getName();
        if (null != field.getAnnotation(ColumnType.class)) {
            property.columnType = field.getAnnotation(ColumnType.class).value();
        } else if (typeFieldMapping.containsKey(property.className) && !typeFieldMapping.get(property.className).isEmpty()) {
            property.columnType = typeFieldMapping.get(property.className);
        } else {
            throw new IllegalArgumentException("\u6307\u5b9a\u5b57\u6bb5\u65e0\u6cd5\u81ea\u52a8\u5339\u914d\u6570\u636e\u5e93\u7c7b\u578b!\u8bf7\u4f7f\u7528@ColumnType\u6ce8\u89e3\u624b\u52a8\u6307\u5b9a!\u7c7b\u540d:" + field.getDeclaringClass().getName() + ",\u5b57\u6bb5\u540d:" + field.getName());
        }
        if (property.columnType.contains("(") && property.columnType.contains(")") && (lengthString = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"))).matches("\\d+")) {
            property.length = Integer.parseInt(lengthString);
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
        if (null != (constraint = field.getDeclaredAnnotation(Constraint.class))) {
            property.notNull = constraint.notNull();
            if (null != property.check) {
                if (!property.check.isEmpty() && !property.check.contains("(")) {
                    property.check = "(" + property.check + ")";
                }
                property.check = property.check.replace("#{" + property.name + "}", property.column);
                property.escapeCheck = property.check.replace(property.column, entityOption.databaseProvider.escape(property.column));
            }
            property.defaultValue = constraint.defaultValue();
        }
        if (null != (id = field.getDeclaredAnnotation(Id.class))) {
            property.id = true;
            property.strategy = id.strategy();
        }
        if (null != (tableField = field.getDeclaredAnnotation(TableField.class))) {
            if (!tableField.function().isEmpty()) {
                String databaseName = entityOption.databaseProvider.name();
                if ("sqlite".equalsIgnoreCase(databaseName) || "h2".equalsIgnoreCase(databaseName) || "sqlserver".equalsIgnoreCase(databaseName)) {
                    logger.warn("sqlite,h2,sqlserver\u6570\u636e\u5e93\u4e0d\u652f\u6301\u6307\u5b9afunction\u5c5e\u6027!");
                } else {
                    property.function = tableField.function().replace("#{" + property.name + "}", "?");
                }
            }
            property.createdAt = tableField.createdAt();
            property.updateAt = tableField.updatedAt();
        }
        ArrayList<Index> indexList = new ArrayList<Index>();
        if (null != field.getDeclaredAnnotation(Index.class)) {
            indexList.add(field.getDeclaredAnnotation(Index.class));
        }
        if (null != (indexes = field.getDeclaredAnnotation(Indexes.class)) && indexes.value().length > 0) {
            indexList.addAll(Arrays.asList(indexes.value()));
        }
        for (Index index : indexList) {
            IndexField indexField = new IndexField();
            indexField.tableName = entity.tableName;
            indexField.indexType = index.indexType();
            indexField.indexName = !index.indexName().isEmpty() ? index.indexName() : entity.tableName + "_" + indexField.indexType.name().toLowerCase() + "_" + property.column;
            indexField.using = index.using();
            indexField.comment = index.comment();
            indexField.columns.add(property.column);
            entity.indexFieldList.add(indexField);
        }
        if (null != field.getDeclaredAnnotation(Comment.class)) {
            property.comment = field.getDeclaredAnnotation(Comment.class).value();
        }
        property.foreignKey = field.getDeclaredAnnotation(ForeignKey.class);
        if (property.id) {
            entity.id = property;
            property.notNull = true;
            property.comment = "\u81ea\u589eid";
            if (property.strategy == IdStrategy.AutoIncrement && null != entityOption.idStrategy) {
                property.strategy = entityOption.idStrategy;
            }
        }
        if (null != property.foreignKey) {
            entity.foreignKeyProperties.add(property);
        }
        property.entity = entity;
        return property;
    }

    private static void getEntity(Entity entity) {
        UniqueField uniqueField;
        CompositeIndexes compositeIndexs;
        Comment comment = EntityUtil.getFirstAnnotation(entity.clazz, Comment.class);
        if (null != comment) {
            entity.comment = comment.value();
        }
        ArrayList<CompositeIndex> compositeIndexList = new ArrayList<CompositeIndex>();
        CompositeIndex compositeIndexAnno = EntityUtil.getFirstAnnotation(entity.clazz, CompositeIndex.class);
        if (null != compositeIndexAnno) {
            compositeIndexList.add(compositeIndexAnno);
        }
        if (null != (compositeIndexs = EntityUtil.getFirstAnnotation(entity.clazz, CompositeIndexes.class))) {
            compositeIndexList.addAll(Arrays.asList(compositeIndexs.value()));
        }
        if (compositeIndexList.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (CompositeIndex compositeIndex : compositeIndexList) {
                if (compositeIndex.columns().length == 0) continue;
                IndexField indexField = new IndexField();
                indexField.tableName = entity.tableName;
                indexField.indexType = compositeIndex.indexType();
                indexField.using = compositeIndex.using();
                for (String column : compositeIndex.columns()) {
                    indexField.columns.add(entity.getColumnNameByFieldName(column));
                }
                indexField.comment = compositeIndex.comment();
                if (!compositeIndex.indexName().isEmpty()) {
                    indexField.indexName = compositeIndex.indexName();
                } else {
                    builder.setLength(0);
                    for (String column : indexField.columns) {
                        builder.append(column + ",");
                    }
                    builder.deleteCharAt(builder.length() - 1);
                    indexField.indexName = entity.tableName + "_" + indexField.indexType.name().toLowerCase() + "_" + builder.toString();
                }
                entity.indexFieldList.add(indexField);
            }
        }
        if (null != (uniqueField = EntityUtil.getFirstAnnotation(entity.clazz, UniqueField.class))) {
            for (String column : uniqueField.columns()) {
                Property property = entity.getPropertyByFieldName(column);
                if (null == property) {
                    throw new IllegalArgumentException("UniqueField\u6ce8\u89e3\u53c2\u6570\u65e0\u6cd5\u5339\u914d\u5b57\u6bb5!\u7c7b:" + entity.clazz.getName() + ",\u5b57\u6bb5:" + column);
                }
                entity.uniqueProperties.add(property);
            }
        }
    }

    private static List<Class> scanPackageClassList(String packageName, EntityOption entityOption) {
        String packageNamePath = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(packageNamePath);
        if (url == null) {
            logger.warn("\u5305\u8def\u5f84\u4e0d\u5b58\u5728,\u5305\u540d:{}", (Object)packageName);
            return new ArrayList<Class>();
        }
        logger.debug("\u51c6\u5907\u626b\u63cf\u5b9e\u4f53\u7c7b\u5305,\u5305\u540d:{}", (Object)packageName);
        final ArrayList<String> classNameList = new ArrayList<String>();
        try {
            switch (url.getProtocol()) {
                case "file": {
                    File file = new File(url.getFile());
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                    }
                    final String indexOfString = packageName.replace(".", "/");
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            File f = file.toFile();
                            if (f.getName().endsWith(".class")) {
                                String path = f.getAbsolutePath().replace("\\", "/");
                                int startIndex = path.indexOf(indexOfString);
                                String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                                classNameList.add(className);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                case "jar": {
                    JarFile jarFile;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                        String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                        classNameList.add(className);
                    }
                    break;
                }
            }
            ArrayList<Class> classList = new ArrayList<Class>(classNameList.size());
            for (String className : classNameList) {
                Class<?> clazz = classLoader.loadClass(className);
                if (EntityUtil.shouldIgnoreClass(clazz, entityOption)) continue;
                classList.add(clazz);
            }
            return classList;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u5b9e\u4f53\u7c7b\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38!", e);
        }
    }

    private static boolean shouldIgnoreClass(Class clazz, EntityOption entityOption) {
        if (clazz.isEnum()) {
            return true;
        }
        if (clazz.getAnnotation(Ignore.class) != null) {
            return true;
        }
        if (null != entityOption.ignoreClassList) {
            for (Class _clazz : entityOption.ignoreClassList) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        if (null != entityOption.ignorePackageNameList) {
            for (String ignorePackageName : entityOption.ignorePackageNameList) {
                if (!clazz.getName().contains(ignorePackageName)) continue;
                return true;
            }
        }
        for (Class _clazz : entityOption.entityClassMap.keySet()) {
            if (!_clazz.getName().equals(clazz.getName())) continue;
            return true;
        }
        return null != entityOption.ignorePredicate && entityOption.ignorePredicate.test(clazz);
    }

    private static Field[] getAllFields(Class clazz, EntityOption entityOption) {
        logger.trace("\u83b7\u53d6\u6307\u5b9a\u7c7b\u7684\u6240\u6709\u5b57\u6bb5!\u7c7b\u540d:{}", (Object)clazz.getName());
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers())) {
                    logger.trace("\u8df3\u8fc7\u5e38\u91cf\u6216\u9759\u6001\u53d8\u91cf,\u8be5\u5b57\u6bb5\u88abstatic\u6216\u8005final\u4fee\u9970!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                if (field.getDeclaredAnnotation(Ignore.class) != null) {
                    logger.trace("\u8df3\u8fc7\u5b9e\u4f53\u5c5e\u6027,\u8be5\u5c5e\u6027\u88abIgnore\u6ce8\u89e3\u4fee\u9970!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                if (((Field)field).getType().isArray() || !((Field)field).getType().isPrimitive() && EntityUtil.isCollection(((Field)field).getType())) {
                    logger.trace("\u8df3\u8fc7\u96c6\u5408\u7c7b\u578b!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                if (EntityUtil.shouldIgnoreClass(((Field)field).getType(), entityOption)) {
                    logger.trace("\u8df3\u8fc7\u7528\u6237\u6307\u5b9a\u8fc7\u6ee4\u6761\u4ef6!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        return fieldList.toArray(new Field[0]);
    }

    private static boolean isCollection(Class clazz) {
        if (clazz.getName().equals(JSONArray.class.getName())) {
            return false;
        }
        Stack<Class<?>[]> stack = new Stack<Class<?>[]>();
        stack.push(clazz.getInterfaces());
        while (!stack.isEmpty()) {
            Class[] classes;
            for (Class _clazz : classes = (Class[])stack.pop()) {
                if (_clazz.getName().equals(Collection.class.getName())) {
                    return true;
                }
                Class<?>[] subClasses = _clazz.getInterfaces();
                if (null == subClasses || subClasses.length <= 0) continue;
                stack.push(subClasses);
            }
        }
        return false;
    }

    private static boolean isCompositProperty(Class clazz, EntityOption entityOption) {
        Set<String> packageNameSet = entityOption.packageNameMap.keySet();
        for (String packageName : packageNameSet) {
            if (!clazz.getName().contains(packageName)) continue;
            return true;
        }
        Set<Class> classSet = entityOption.entityClassMap.keySet();
        for (Class c : classSet) {
            if (!c.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private static <T> T getFirstAnnotation(Class clazz, Class<T> annotation) {
        T annotation1 = null;
        while (null != clazz && null == annotation1) {
            annotation1 = clazz.getDeclaredAnnotation(annotation);
            clazz = clazz.getSuperclass();
        }
        return annotation1;
    }
}

