/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersUtil {
    private static Logger logger = LoggerFactory.getLogger(ParametersUtil.class);
    private static final String PLACEHOLDER = "** NOT SPECIFIED **";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void setGeneratedKeysValue(Object instance, Entity entity, String generatedKeys) {
        Field idField = ParametersUtil.getFieldFromInstance(instance, entity.id.name);
        try {
            switch (idField.getType().getName()) {
                case "int": {
                    idField.setInt(instance, Integer.parseInt(generatedKeys));
                    break;
                }
                case "java.lang.Integer": {
                    idField.set(instance, Integer.valueOf(generatedKeys));
                    break;
                }
                case "long": {
                    idField.setLong(instance, Long.parseLong(generatedKeys));
                    break;
                }
                case "java.lang.Long": {
                    idField.set(instance, Long.valueOf(generatedKeys));
                    break;
                }
                case "java.lang.String": {
                    idField.set(instance, generatedKeys);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u5f53\u524d\u4ec5\u652f\u6301int,long,String\u7c7b\u578b\u7684\u81ea\u589e\u4e3b\u952e!\u81ea\u589e\u5b57\u6bb5\u540d\u79f0:" + idField.getName() + ",\u7c7b\u578b:" + idField.getType().getName() + "!");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bbe\u7f6e\u4e3b\u952e\u81ea\u589e\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public static void setCurrentDateTime(Property property, Object instance) {
        Field field = ParametersUtil.getFieldFromInstance(instance, property.name);
        try {
            Object value = field.get(instance);
            if (null != value) {
                return;
            }
            switch (property.className) {
                case "java.util.Date": {
                    field.set(instance, new java.util.Date(System.currentTimeMillis()));
                    break;
                }
                case "java.sql.Date": {
                    field.set(instance, new Date(System.currentTimeMillis()));
                    break;
                }
                case "java.sql.Timestamp": {
                    field.set(instance, new Timestamp(System.currentTimeMillis()));
                    break;
                }
                case "java.util.Calendar": {
                    field.set(instance, Calendar.getInstance());
                    break;
                }
                case "java.time.LocalDate": {
                    field.set(instance, LocalDate.now());
                    break;
                }
                case "java.time.LocalDateTime": {
                    field.set(instance, LocalDateTime.now());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u7c7b\u578b,\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!\u5f53\u524d\u7c7b\u578b:" + property.className);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bbe\u7f6e\u5f53\u524d\u65f6\u95f4\u5f02\u5e38", e);
        }
    }

    public static String replaceStatementPlaceholder(String sql, Collection parameters) {
        StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", PLACEHOLDER));
        if (null != parameters && !parameters.isEmpty()) {
            for (Object parameter : parameters) {
                String parameterPlaceHolder = ParametersUtil.getParameterPlaceHolder(parameter);
                int indexOf = sqlBuilder.indexOf(PLACEHOLDER);
                sqlBuilder.replace(indexOf, indexOf + PLACEHOLDER.length(), parameterPlaceHolder);
            }
        }
        String formatSQL = sqlBuilder.toString();
        return formatSQL;
    }

    public static void setPrepareStatementParameter(PreparedStatement ps, Collection parameters, String databaseName) throws SQLException {
        if (null == parameters) {
            return;
        }
        int parameterIndex = 1;
        for (Object parameter : parameters) {
            if (null == parameter) {
                ps.setObject(parameterIndex, null);
            } else {
                block31 : switch (parameter.getClass().getName()) {
                    case "byte": {
                        ps.setByte(parameterIndex, (Byte)parameter);
                        break;
                    }
                    case "[B": {
                        ps.setBytes(parameterIndex, (byte[])parameter);
                        break;
                    }
                    case "boolean": {
                        boolean value = (Boolean)parameter;
                        ps.setBoolean(parameterIndex, value);
                        break;
                    }
                    case "short": {
                        ps.setShort(parameterIndex, (Short)parameter);
                        break;
                    }
                    case "int": {
                        ps.setInt(parameterIndex, (Integer)parameter);
                        break;
                    }
                    case "float": {
                        ps.setFloat(parameterIndex, ((Float)parameter).floatValue());
                        break;
                    }
                    case "long": {
                        ps.setLong(parameterIndex, (Long)parameter);
                        break;
                    }
                    case "double": {
                        ps.setDouble(parameterIndex, (Double)parameter);
                        break;
                    }
                    case "java.lang.String": {
                        ps.setString(parameterIndex, (String)parameter);
                        break;
                    }
                    case "java.util.Date": {
                        java.util.Date date = (java.util.Date)parameter;
                        ps.setDate(parameterIndex, new Date(date.getTime()));
                        break;
                    }
                    case "java.sql.Date": {
                        Date date = (Date)parameter;
                        ps.setDate(parameterIndex, date);
                        break;
                    }
                    case "java.sql.Time": {
                        Time time = (Time)parameter;
                        ps.setTime(parameterIndex, time);
                        break;
                    }
                    case "java.sql.Timestamp": {
                        Timestamp timestamp = (Timestamp)parameter;
                        ps.setTimestamp(parameterIndex, timestamp);
                        break;
                    }
                    case "java.time.LocalDate": {
                        LocalDate localDate = (LocalDate)parameter;
                        switch (databaseName.toLowerCase()) {
                            case "oracle": {
                                ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
                                Date date = new Date(Date.from(zonedDateTime.toInstant()).getTime());
                                ps.setObject(parameterIndex, date);
                                break block31;
                            }
                        }
                        ps.setObject(parameterIndex, localDate);
                        break;
                    }
                    case "java.time.LocalDateTime": {
                        LocalDateTime localDateTime = (LocalDateTime)parameter;
                        switch (databaseName.toLowerCase()) {
                            case "oracle": {
                                ZoneId zoneId = ZoneId.systemDefault();
                                Instant instant = localDateTime.atZone(zoneId).toInstant();
                                Timestamp timestamp = new Timestamp(instant.toEpochMilli());
                                ps.setObject(parameterIndex, timestamp);
                                break block31;
                            }
                        }
                        ps.setObject(parameterIndex, localDateTime);
                        break;
                    }
                    case "java.sql.Array": {
                        ps.setArray(parameterIndex, (Array)parameter);
                        break;
                    }
                    case "java.math.BigDecimal": {
                        ps.setBigDecimal(parameterIndex, (BigDecimal)parameter);
                        break;
                    }
                    case "java.sql.Blob": {
                        ps.setBlob(parameterIndex, (Blob)parameter);
                        break;
                    }
                    case "java.sql.Clob": {
                        ps.setClob(parameterIndex, (Clob)parameter);
                        break;
                    }
                    case "java.sql.NClob": {
                        ps.setNClob(parameterIndex, (NClob)parameter);
                        break;
                    }
                    case "java.sql.Ref": {
                        ps.setRef(parameterIndex, (Ref)parameter);
                        break;
                    }
                    case "java.net.URL": {
                        ps.setURL(parameterIndex, (URL)parameter);
                        break;
                    }
                    case "java.sql.RowId": {
                        ps.setRowId(parameterIndex, (RowId)parameter);
                        break;
                    }
                    case "java.sql.SQLXML": {
                        ps.setSQLXML(parameterIndex, (SQLXML)parameter);
                        break;
                    }
                    case "java.io.InputStream": {
                        ps.setBinaryStream(parameterIndex, (InputStream)parameter);
                        break;
                    }
                    case "java.io.Reader": {
                        ps.setCharacterStream(parameterIndex, (Reader)parameter);
                        break;
                    }
                    case "com.alibaba.fastjson.JSONObject": {
                        JSONObject o = (JSONObject)parameter;
                        String jsonString = o.toJSONString();
                        ps.setObject(parameterIndex, jsonString);
                        break;
                    }
                    case "com.alibaba.fastjson.JSONArray": {
                        JSONArray o = (JSONArray)parameter;
                        String jsonString = o.toJSONString();
                        ps.setObject(parameterIndex, jsonString);
                        break;
                    }
                    default: {
                        try {
                            ps.setObject(parameterIndex, parameter);
                            break;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            logger.trace("\u8bbe\u7f6e\u53c2\u6570,\u7d22\u5f15:{},\u503c:{}", (Object)parameterIndex, parameter);
            ++parameterIndex;
        }
    }

    private static String getParameterPlaceHolder(Object parameter) {
        if (null == parameter) {
            return "null";
        }
        String parameterSQL = parameter.toString();
        switch (parameter.getClass().getName()) {
            case "boolean": {
                boolean value = (Boolean)parameter;
                parameterSQL = value ? "1" : "0";
                break;
            }
            case "java.lang.String": 
            case "com.alibaba.fastjson.JSONObject": 
            case "com.alibaba.fastjson.JSONArray": {
                parameterSQL = "'" + parameter.toString() + "'";
                break;
            }
            case "java.util.Date": {
                java.util.Date date = (java.util.Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Date": {
                Date date = (Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Time": {
                Time time = (Time)parameter;
                parameterSQL = "'" + simpleTimeFormat.format(time) + "'";
                break;
            }
            case "java.sql.Timestamp": {
                Timestamp timestamp = (Timestamp)parameter;
                parameterSQL = "'" + simpleDateTimeFormat.format(timestamp) + "'";
                break;
            }
            case "java.time.LocalDate": {
                LocalDate localDate = (LocalDate)parameter;
                parameterSQL = "'" + localDate.format(dateFormatter) + "'";
                break;
            }
            case "java.time.LocalDateTime": {
                LocalDateTime localDateTime = (LocalDateTime)parameter;
                parameterSQL = "'" + localDateTime.format(dateTimeFormatter) + "'";
            }
        }
        return parameterSQL;
    }

    public static List getFieldValueListFromInstance(Object[] instances, String name) {
        Field field = ParametersUtil.getFieldFromInstance(instances[0], name);
        ArrayList<Object> valueList = new ArrayList<Object>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            Object value = null;
            try {
                value = field.get(instances[i]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b\u5b57\u6bb5\u503c\u5931\u8d25", e);
            }
            valueList.add(value);
        }
        return valueList;
    }

    public static Object getFieldValueFromInstance(Object instance, String name) {
        Field field = ParametersUtil.getFieldFromInstance(instance, name);
        try {
            Object value = field.get(instance);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b\u5b57\u6bb5\u503c\u5931\u8d25", e);
        }
    }

    public static Field getFieldFromInstance(Object instance, String name) {
        Field field = null;
        block0: for (Class<?> tempClass = instance.getClass(); null == field && null != tempClass; tempClass = tempClass.getSuperclass()) {
            Field[] fields;
            for (Field field1 : fields = tempClass.getDeclaredFields()) {
                if (!field1.getName().equals(name)) continue;
                field = field1;
                continue block0;
            }
        }
        if (null == field) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b57\u6bb5\u540d:" + name + ",\u7c7b\u540d:" + instance.getClass().getName());
        }
        field.setAccessible(true);
        return field;
    }
}

