/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import java.util.HashMap;
import java.util.Map;

public class H2DatabaseProvider
implements DatabaseProvider {
    private Map<String, String> fieldTypeMapping = new HashMap<String, String>();

    public H2DatabaseProvider() {
        this.fieldTypeMapping.put("byte", "TINYINT");
        this.fieldTypeMapping.put("java.lang.Byte", "TINYINT");
        this.fieldTypeMapping.put("[B", "BINARY");
        this.fieldTypeMapping.put("boolean", "BOOLEAN");
        this.fieldTypeMapping.put("java.lang.Boolean", "BOOLEAN");
        this.fieldTypeMapping.put("char", "CHAR");
        this.fieldTypeMapping.put("java.lang.Character", "CHARACTER");
        this.fieldTypeMapping.put("short", "SMALLINT");
        this.fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        this.fieldTypeMapping.put("int", "INT");
        this.fieldTypeMapping.put("java.lang.Integer", "INTEGER");
        this.fieldTypeMapping.put("float", "REAL");
        this.fieldTypeMapping.put("java.lang.Float", "REAL");
        this.fieldTypeMapping.put("long", "BIGINT");
        this.fieldTypeMapping.put("java.lang.Long", "BIGINT");
        this.fieldTypeMapping.put("double", "DOUBLE");
        this.fieldTypeMapping.put("java.lang.Double", "DOUBLE");
        this.fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        this.fieldTypeMapping.put("java.util.Date", "DATETIME");
        this.fieldTypeMapping.put("java.sql.Date", "DATE");
        this.fieldTypeMapping.put("java.sql.Time", "TIME");
        this.fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        this.fieldTypeMapping.put("java.time.LocalDate", "DATE");
        this.fieldTypeMapping.put("java.time.LocalDateTime", "DATETIME");
        this.fieldTypeMapping.put("java.sql.Array", "ARRAY");
        this.fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        this.fieldTypeMapping.put("java.sql.Blob", "BLOB");
        this.fieldTypeMapping.put("java.sql.Clob", "CLOB");
        this.fieldTypeMapping.put("java.sql.NClob", "NCLOB");
        this.fieldTypeMapping.put("java.sql.Ref", "");
        this.fieldTypeMapping.put("java.net.URL", "");
        this.fieldTypeMapping.put("java.sql.RowId", "");
        this.fieldTypeMapping.put("java.sql.SQLXML", "");
        this.fieldTypeMapping.put("java.io.InputStream", "LONGTEXT");
        this.fieldTypeMapping.put("java.io.Reader", "LONGTEXT");
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "`" + value.toUpperCase() + "`";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        return this.fieldTypeMapping;
    }

    @Override
    public String name() {
        return "h2";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.H2;
    }
}

