/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dcl.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.database.dcl.GrantOption;
import cn.schoolwow.quickdao.module.database.dcl.kit.DatabaseControl;
import cn.schoolwow.quickdao.module.database.dcl.service.CreateUserAndGrantFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.CreateUserFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.DeleteUserFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.FlushPrivilegesFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.GetUserNameListFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.GrantFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.ModifyPasswordFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.RevokeFlow;
import cn.schoolwow.quickdao.module.database.parent.kit.DatabaseDAOImpl;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class DatabaseControlImpl
extends DatabaseDAOImpl
implements DatabaseControl {
    public DatabaseControlImpl(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        super(quickFlow, quickDAOConfig);
    }

    @Override
    public List<String> getUserNameList() {
        FlowContext flowContext = this.quickFlow.executeFlow(new BusinessFlow[]{new GetUserNameListFlow()});
        List userNameList = (List)flowContext.getData("userNameList");
        return userNameList;
    }

    @Override
    public boolean hasUserName(String username) {
        List<String> userNameList = this.getUserNameList();
        for (String username1 : userNameList) {
            if (!username1.equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) {
        this.quickFlow.startFlow((BusinessFlow)new CreateUserFlow()).putReturnData("dataBaseUser", (Object)dataBaseUser).execute();
    }

    @Override
    public void modifyPassword(String username, String newPassword) {
        this.quickFlow.startFlow((BusinessFlow)new ModifyPasswordFlow()).putReturnData("username", (Object)username).putReturnData("newPassword", (Object)newPassword).execute();
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) {
        this.quickFlow.startFlow((BusinessFlow)new DeleteUserFlow()).putReturnData("dataBaseUser", (Object)dataBaseUser).execute();
    }

    @Override
    public void grant(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new GrantFlow()).putReturnData("grantOption", (Object)grantOption).execute();
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new CreateUserAndGrantFlow()).putReturnData("grantOption", (Object)grantOption).execute();
    }

    @Override
    public void revoke(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new RevokeFlow()).putReturnData("grantOption", (Object)grantOption).execute();
    }

    @Override
    public void flushPrivileges() {
        this.quickFlow.executeFlow(new BusinessFlow[]{new FlushPrivilegesFlow()});
    }
}

