/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.createTable;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.BuildForeignKeyFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.BuildIndexFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.CheckOpenForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SQLiteCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new CheckOpenForeignKeyFlow()});
        this.buildColumn(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildForeignKeyFlow()});
        this.buildTableComment(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildIndexFlow()});
    }

    public String name() {
        return "SQLite\u6570\u636e\u5e93\u521b\u5efa\u8868";
    }

    private void buildColumn(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        sqlBuilder.append("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("propertyOption", (Object)property).execute();
            } else {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.range ? "" : "(" + property.range + ")"));
                if (null != property.notNull && property.notNull.booleanValue()) {
                    sqlBuilder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    sqlBuilder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    sqlBuilder.append(" check " + property.escapeCheck);
                }
            }
            sqlBuilder.append(",");
        }
    }

    private void buildTableComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        if (null != entity.comment) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(entity.comment));
        }
        sqlBuilder.append(");");
    }
}

