/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.has;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.module.database.ddl.flow.has.common.SetHasResultSetFlow;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.Arrays;

public class HasIndexFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.putTemporaryData("name", (Object)"\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728");
        switch (databaseType) {
            case H2: {
                flowContext.putTemporaryData("sql", (Object)"select index_name from information_schema.indexes where index_name = ?;");
                flowContext.putTemporaryData("parameters", Arrays.asList(indexName));
                break;
            }
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)"select name from sqlite_master where type = 'index' and name = ?;");
                flowContext.putTemporaryData("parameters", Arrays.asList(indexName));
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)("show index from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " where key_name = ?;"));
                flowContext.putTemporaryData("parameters", Arrays.asList(indexName));
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)"select indexname from pg_indexes where tablename = ? and indexname = ?;");
                flowContext.putTemporaryData("parameters", Arrays.asList(tableName, indexName));
                break;
            }
            case SQLServer: {
                flowContext.putTemporaryData("sql", (Object)"select name from sys.indexes WHERE object_id=OBJECT_ID(?, N'U') and name = ?;");
                flowContext.putTemporaryData("parameters", Arrays.asList(tableName, indexName));
                break;
            }
            case Oracle: {
                flowContext.putTemporaryData("sql", (Object)"select index_name from user_indexes where table_name = ? and index_name = ?");
                flowContext.putTemporaryData("parameters", Arrays.asList(tableName, indexName));
            }
        }
        flowContext.executeFlowList(new BusinessFlow[]{new SetHasResultSetFlow(), new ExecuteQueryConnectionFlow()});
    }

    public String name() {
        return "\u7d22\u5f15\u662f\u5426\u5b58\u5728";
    }
}

