/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.GetPropertyFlow;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DropTableColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.checkCanAlterTableColumn(flowContext);
        this.dropTableColumn(flowContext);
    }

    public String name() {
        return "\u5220\u9664\u8868\u5b57\u6bb5";
    }

    private void checkCanAlterTableColumn(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case SQLite: {
                throw new IllegalArgumentException("SQLite\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5220\u9664\u5b57\u6bb5");
            }
        }
    }

    private void dropTableColumn(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyFlow()});
        Property property = (Property)flowContext.getData("property");
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        if (null == property) {
            throw new IllegalArgumentException("\u88ab\u5220\u9664\u7684\u5217\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5217\u540d:" + columnName);
        }
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u5220\u9664\u5217").putTemporaryData("sql", (Object)("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " drop column " + quickDAOConfig.databaseContext.databaseProvider.escape(columnName) + ";")).execute();
    }
}

