/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityPropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
        Entity entity = (Entity)flowContext.checkData("entity");
        for (Property property : entity.properties) {
            if (!property.columnType.contains("(") || !property.columnType.contains(")")) continue;
            property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868";
    }

    private void getByH2(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select column_name, type_name, character_maximum_length, is_nullable, column_default from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ?;")).putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("type_name");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                    }
                    entity.properties.add(property);
                }
            }
        }).execute();
    }

    private void getBySQLite(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("PRAGMA table_info(`" + entity.tableName + "`);")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("name");
                    property.columnType = resultSet.getString("type");
                    property.notNull = "1".equals(resultSet.getString("notnull"));
                    if (null != resultSet.getString("dflt_value")) {
                        property.defaultValue = resultSet.getString("dflt_value");
                    }
                    if (1 == resultSet.getInt("pk")) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                    entity.properties.add(property);
                }
            }
        }).execute();
    }

    private void getByMysql(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select column_name, column_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? order by table_name asc, ordinal_position asc;")).putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    String key = resultSet.getString("column_key");
                    if ("PRI".equals(key)) {
                        property.id = true;
                    }
                    if ("auto_increment".equals(resultSet.getString("extra"))) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    } else {
                        property.strategy = IdStrategy.None;
                    }
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                        if (!property.defaultValue.contains("CURRENT_TIMESTAMP") && !property.defaultValue.contains("'")) {
                            property.defaultValue = "'" + property.defaultValue + "'";
                        }
                    }
                    property.comment = resultSet.getString("column_comment").replace("\"", "\\\"");
                    entity.properties.add(property);
                }
            }
        }).execute();
    }

    private void getByPostgres(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("type");
                    property.notNull = "t".equals(resultSet.getString("notnull"));
                    property.comment = resultSet.getString("comment");
                    entity.properties.add(property);
                }
            }
        }).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select ordinal_position,column_name,column_default,is_nullable,udt_name,character_maximum_length,column_default from information_schema.columns where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.columnType = resultSet.getString("udt_name");
                        if (null == resultSet.getString("column_default")) continue;
                        property.defaultValue = resultSet.getString("column_default");
                        if (!property.defaultValue.startsWith("nextval(")) continue;
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                }
            }
        }).execute();
    }

    private void getBySQLServer(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select ordinal_position,column_name,data_type,is_nullable,character_maximum_length from information_schema.columns where table_name = ?;").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("data_type");
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    entity.properties.add(property);
                }
            }
        }).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select c.name column_name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id and b.name = ?;").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.comment = resultSet.getString("value");
                    }
                }
            }
        }).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4e3b\u952e").putTemporaryData("sql", (Object)"select column_name from information_schema.key_column_usage where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                }
            }
        }).execute();
    }

    private void getByOracle(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select column_name, data_type, nullable, data_length from user_tab_columns where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("data_type");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    String dataLength = resultSet.getString("data_length");
                    if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                        property.columnType = property.columnType + "(" + dataLength + ")";
                    }
                    property.notNull = "N".equals(resultSet.getString("nullable"));
                    entity.properties.add(property);
                }
            }
        }).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select column_name, comments from user_col_comments where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.comment = resultSet.getString("comments");
                    }
                }
            }
        }).execute();
    }
}

