/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetPropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
        Property property = (Property)flowContext.getData("property");
        if (null != property && property.columnType.contains("(") && property.columnType.contains(")")) {
            property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868";
    }

    private void getByH2(final FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select type_name, is_nullable, column_default from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and column_name = ?;")).putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("type_name");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                    }
                    flowContext.putData("property", (Object)property);
                }
            }
        }).execute();
    }

    private void getBySQLite(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        final String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("PRAGMA table_info(`" + tableName + "`);")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String resultSetColumnName = resultSet.getString("name");
                    if (!resultSetColumnName.equalsIgnoreCase(columnName)) continue;
                    Property property = new Property();
                    property.column = columnName;
                    property.columnType = resultSet.getString("type");
                    property.notNull = "1".equals(resultSet.getString("notnull"));
                    if (null != resultSet.getString("dflt_value")) {
                        property.defaultValue = resultSet.getString("dflt_value");
                    }
                    if (1 == resultSet.getInt("pk")) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                    flowContext.putData("property", (Object)property);
                    break;
                }
            }
        }).execute();
    }

    private void getByMysql(final FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select column_name, column_type, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and column_name = ? order by table_name asc, ordinal_position asc;")).putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" ")).trim();
                    }
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    String key = resultSet.getString("column_key");
                    if ("PRI".equals(key)) {
                        property.id = true;
                    }
                    if ("auto_increment".equals(resultSet.getString("extra"))) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    } else {
                        property.strategy = IdStrategy.None;
                    }
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                        if (!property.defaultValue.contains("CURRENT_TIMESTAMP") && !property.defaultValue.contains("'")) {
                            property.defaultValue = "'" + property.defaultValue + "'";
                        }
                    }
                    property.comment = resultSet.getString("column_comment").replace("\"", "\\\"");
                    flowContext.putData("property", (Object)property);
                }
            }
        }).execute();
    }

    private void getByPostgres(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ? and attname = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("type");
                    property.notNull = "t".equals(resultSet.getString("notnull"));
                    property.comment = resultSet.getString("comment");
                    flowContext.putData("property", (Object)property);
                }
            }
        }).execute();
        if (!flowContext.containKey("property")) {
            flowContext.broken("\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        final Property property = (Property)flowContext.checkData("property");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select ordinal_position,column_default,is_nullable,udt_name,column_default from information_schema.columns where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    property.columnType = resultSet.getString("udt_name");
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                        if (property.defaultValue.startsWith("nextval(")) {
                            property.id = true;
                            property.strategy = IdStrategy.AutoIncrement;
                        }
                    }
                }
            }
        }).execute();
    }

    private void getBySQLServer(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select ordinal_position,column_type,is_nullable from information_schema.columns where table_name = ? and column_name = ?;").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    flowContext.putData("property", (Object)property);
                }
            }
        }).execute();
        if (flowContext.containKey("property")) {
            flowContext.broken("\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        final Property property = (Property)flowContext.checkData("property");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id and b.name = ? and c.name = ?;").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    property.comment = resultSet.getString("value");
                }
            }
        }).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4e3b\u952e").putTemporaryData("sql", (Object)"select column_name from information_schema.key_column_usage where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    property.id = true;
                    property.strategy = IdStrategy.AutoIncrement;
                }
            }
        }).execute();
    }

    private void getByOracle(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select column_type, nullable, data_length from user_tab_columns where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    String dataLength = resultSet.getString("data_length");
                    if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                        property.columnType = property.columnType + "(" + dataLength + ")";
                    }
                    property.notNull = "N".equals(resultSet.getString("nullable"));
                    flowContext.putData("property", (Object)property);
                }
            }
        }).execute();
        if (flowContext.containKey("property")) {
            flowContext.broken("\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        final Property property = (Property)flowContext.checkData("property");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select comments from user_col_comments where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    property.comment = resultSet.getString("comments");
                }
            }
        }).execute();
    }
}

