/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.PropertyOption;
import cn.schoolwow.quickdao.module.database.ddl.service.constraint.HasConstraintFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateForeignKeyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.checkConstraintExist(flowContext);
        this.executeCreateForeignKey(flowContext);
    }

    public String name() {
        return "\u521b\u5efa\u5916\u952e\u7ea6\u675f";
    }

    private void checkConstraintExist(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption)flowContext.checkData("propertyOption");
        String foreignKeyName = "FK_" + tableName + "_" + propertyOption.foreignKey.field() + "_" + quickDAOConfig.getEntityByClassName((String)propertyOption.foreignKey.table().getName()).tableName + "_" + propertyOption.name;
        boolean hasResult = (Boolean)flowContext.startFlow((BusinessFlow)new HasConstraintFlow()).putTemporaryData("constraintName", (Object)foreignKeyName).execute().checkData("hasResult");
        if (hasResult) {
            flowContext.broken("\u5916\u952e\u7ea6\u675f\u5df2\u5b58\u5728");
        } else {
            flowContext.putTemporaryData("foreignKeyName", (Object)foreignKeyName);
        }
    }

    private void executeCreateForeignKey(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption)flowContext.checkData("propertyOption");
        String foreignKeyName = (String)flowContext.checkData("foreignKeyName");
        String operation = propertyOption.foreignKey.foreignKeyOption().getOperation();
        String reference = quickDAOConfig.databaseContext.databaseProvider.escape(quickDAOConfig.getEntityByClassName((String)propertyOption.foreignKey.table().getName()).tableName) + "(" + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String createForeignKeySQL = "alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " add constraint " + quickDAOConfig.databaseContext.databaseProvider.escape(foreignKeyName) + " foreign key(" + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + ") references " + reference + ";";
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u521b\u5efa\u5916\u952e\u7ea6\u675f").putTemporaryData("sql", (Object)createForeignKeySQL).execute();
    }
}

