/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dml.flow.common;

import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.math.BigDecimal;

public class CheckFieldConstraintFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Property property = (Property)flowContext.checkData("property");
        Object value = flowContext.getData("value");
        if (property.id || property.createdAt || property.updateAt) {
            return;
        }
        if (null != property.notNull && property.notNull.booleanValue() && null == value) {
            flowContext.putData("reason", (Object)("\u5b57\u6bb5" + property.column + "\u7684\u503c\u4e3a\u7a7a"));
            return;
        }
        if (null == value) {
            return;
        }
        String reason = null;
        switch (property.columnType.toLowerCase()) {
            case "mediumint": {
                int intValue = (Integer)value;
                if (intValue >= -8388608 && intValue <= 0xFFFFFF) break;
                reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3amediumint,\u9650\u5236\u8303\u56f4\u4e3a[-8388608,16777215],\u5f53\u524d\u503c\u4e3a" + intValue;
                break;
            }
            case "char": {
                int valueLength = value.toString().length();
                if (valueLength <= 255) break;
                reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3achar,\u9650\u5236\u957f\u5ea6\u4e3a[0,255],\u5f53\u524d\u957f\u5ea6\u4e3a" + valueLength;
                break;
            }
            case "varchar": {
                int maxLength;
                if (null == property.range) break;
                int valueLength = value.toString().length();
                int n = maxLength = null == property.range ? 65535 : Math.min(Integer.parseInt(property.range), 65535);
                if (valueLength <= maxLength) break;
                reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3avarchar,\u9650\u5236\u957f\u5ea6\u4e3a[0," + maxLength + "],\u5f53\u524d\u957f\u5ea6\u4e3a" + valueLength;
                break;
            }
            case "text": {
                int valueLength = value.toString().length();
                if (valueLength <= 65535) break;
                reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3atext,\u9650\u5236\u957f\u5ea6\u4e3a[0,65535],\u5f53\u524d\u957f\u5ea6\u4e3a" + valueLength;
                break;
            }
            case "decimal": {
                if (null == property.range) break;
                BigDecimal number = (BigDecimal)value;
                int integerDigits = number.precision() - number.scale();
                int decimalDigits = number.scale();
                int limitIntegerDigits = Integer.parseInt(property.range.substring(0, property.range.indexOf(",")));
                if (integerDigits > limitIntegerDigits) {
                    reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3adecimal(" + property.range + "),\u6574\u6570\u4f4d\u6570\u8d85\u8fc7\u9650\u5236,\u5f53\u524d\u6574\u6570\u4f4d\u6570\u4e3a" + integerDigits + ",\u5c0f\u6570\u4f4d\u6570\u4e3a" + decimalDigits + ",\u6570\u503c\u4e3a" + number;
                    break;
                }
                int limitDecimalDigits = Integer.parseInt(property.range.substring(property.range.indexOf(",") + 1));
                if (decimalDigits <= limitDecimalDigits) break;
                reason = "\u5b57\u6bb5" + property.column + "\u7c7b\u578b\u4e3adecimal(" + property.range + "),\u5c0f\u6570\u4f4d\u6570\u8d85\u8fc7\u9650\u5236,\u5f53\u524d\u6574\u6570\u4f4d\u6570\u4e3a" + integerDigits + ",\u5c0f\u6570\u4f4d\u6570\u4e3a" + decimalDigits + ",\u6570\u503c\u4e3a" + number;
                break;
            }
        }
        flowContext.putData("reason", reason);
    }

    public String name() {
        return "\u68c0\u67e5\u5b57\u6bb5\u7ea6\u675f";
    }
}

