/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dml.flow.instance.insert.get;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.GetStatementSupplier;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetUniqueKeyValueListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        if (entity.uniqueProperties.isEmpty()) {
            flowContext.brokenCurrentFlow("\u5b9e\u4f53\u7c7b\u672a\u8bbe\u7f6e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5!");
        }
        this.setStatement(flowContext);
        flowContext.putTemporaryData("uniqueKeyValueList", new ArrayList());
        Object[] instances = (Object[])flowContext.checkData("instances");
        for (int i = 0; i < instances.length; ++i) {
            flowContext.putTemporaryData("instance", instances[i]);
            this.setParameters(flowContext);
            this.executeStatement(flowContext);
            flowContext.removeData("instance");
        }
    }

    public String name() {
        return "\u6839\u636e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u5b57\u6bb5\u503c";
    }

    private void setStatement(FlowContext flowContext) {
        final QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new GetAndCacheStatementFlow()).putReturnData("sqlCacheName", (Object)("getUniqueKeyValue_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())).putTemporaryData("getStatementSupplier", (Object)new GetStatementSupplier(){

            @Override
            public String getStatement() {
                StringBuilder sqlBuilder = new StringBuilder("select");
                for (Property uniqueProperty : entity.uniqueProperties) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueProperty.column) + ",");
                }
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where");
                for (Property uniqueProperty : entity.uniqueProperties) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueProperty.column) + " = ? and");
                }
                sqlBuilder.delete(sqlBuilder.length() - 4, sqlBuilder.length());
                return sqlBuilder.toString();
            }
        }).execute();
    }

    private void setParameters(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Property uniqueProperty : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
            if (null == value) {
                throw new IllegalArgumentException("\u5b9e\u4f8b\u552f\u4e00\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!\u5b9e\u4f53\u7c7b:" + instance.getClass().getName() + ",\u5b57\u6bb5\u540d:" + uniqueProperty.name);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        final List uniqueKeyValueList = (List)flowContext.getData("uniqueKeyValueList");
        final StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u6839\u636e\u591a\u4e2a\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u5b57\u6bb5\u503c").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    uniqueFieldNameValueBuilder.setLength(0);
                    for (Property uniqueProperty : entity.uniqueProperties) {
                        uniqueFieldNameValueBuilder.append(resultSet.getString(uniqueProperty.column) + "|");
                    }
                    uniqueKeyValueList.add(uniqueFieldNameValueBuilder.toString());
                }
            }
        }).execute();
    }
}

