/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dml.flow.json.common.filter;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.dml.domain.ManipulationOption;
import cn.schoolwow.quickdao.module.database.dml.flow.common.CheckFieldConstraintFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FilterJSONArrayByConstraintFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.shouldCheck(flowContext);
        this.filterInstanceByConstraint(flowContext);
    }

    public String name() {
        return "\u8fc7\u6ee4\u5b57\u6bb5\u503c\u4e0d\u7b26\u5408\u5b57\u6bb5\u7ea6\u675f\u7684JSONObject";
    }

    private void shouldCheck(FlowContext flowContext) {
        CheckStrategy checkStrategy;
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        CheckStrategy checkStrategy2 = checkStrategy = null != manipulationOption.checkStrategy ? manipulationOption.checkStrategy : quickDAOConfig.databaseOption.checkStrategy;
        if (CheckStrategy.None.equals((Object)checkStrategy)) {
            flowContext.brokenCurrentFlow("\u6839\u636e\u5b57\u6bb5\u7ea6\u675f\u7b56\u7565,\u8df3\u8fc7\u8fc7\u6ee4\u5b57\u6bb5\u503c\u4e0d\u7b26\u5408\u5b57\u6bb5\u7ea6\u675f\u7684\u5b9e\u4f8b");
        }
    }

    private void filterInstanceByConstraint(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        JSONArray instances = (JSONArray)flowContext.checkData("instances");
        Map instanceReasonMap = (Map)flowContext.getData("instanceReasonMap", new LinkedHashMap());
        JSONArray filterInstances = new JSONArray();
        filterInstances.addAll((Collection)instances);
        Iterator iterator = filterInstances.iterator();
        while (iterator.hasNext()) {
            JSONObject instance = (JSONObject)iterator.next();
            for (Property property : entity.properties) {
                Object value = instance.get((Object)property.column);
                String reason = (String)flowContext.getQuickFlow().startFlow((BusinessFlow)new CheckFieldConstraintFlow()).putTemporaryData("property", (Object)property).putTemporaryData("value", value).execute().getData("reason");
                if (null == reason) continue;
                if (!instanceReasonMap.containsKey(instance)) {
                    instanceReasonMap.put(instance, reason);
                    continue;
                }
                String oldReason = (String)instanceReasonMap.get(instance);
                instanceReasonMap.put(instance, oldReason + ";" + reason);
            }
            if (!instanceReasonMap.containsKey(instance)) continue;
            iterator.remove();
        }
        if (filterInstances.isEmpty()) {
            flowContext.putData("effect", (Object)0);
            flowContext.broken("\u6839\u636e\u5b57\u6bb5\u7ea6\u675f\u8fc7\u6ee4\u6570\u636e\u540e\u5b9e\u4f8b\u5217\u8868\u4e3a\u7a7a");
        }
        flowContext.putData("instances", (Object)filterInstances);
    }
}

