/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dql.query.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.dql.condition.domain.SFunction;
import cn.schoolwow.quickdao.module.database.dql.query.kit.DatabaseQuery;
import cn.schoolwow.quickdao.module.database.dql.query.service.exist.GetInstanceCountFlow;
import cn.schoolwow.quickdao.module.database.dql.query.service.exist.GetInstancesCountFlow;
import cn.schoolwow.quickdao.module.database.dql.query.service.fetch.FetchListFlow;
import cn.schoolwow.quickdao.module.database.dql.query.service.fetch.FetchNullFlow;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.module.database.parent.kit.DatabaseDAOImpl;
import cn.schoolwow.quickdao.util.LambdaUtils;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DatabaseQueryImpl
extends DatabaseDAOImpl
implements DatabaseQuery {
    public DatabaseQueryImpl(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        super(quickFlow, quickDAOConfig);
    }

    @Override
    public boolean exist(Object instance) {
        if (null == instance) {
            return false;
        }
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new GetInstanceCountFlow()).putTemporaryData("instance", instance).execute();
        Long count = (Long)flowContext.checkData("count");
        return count > 0L;
    }

    @Override
    public boolean existAny(Object ... instances) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new GetInstancesCountFlow()).putTemporaryData("instances", (Object)instances).execute();
        Long count = (Long)flowContext.checkData("count");
        return count > 0L;
    }

    @Override
    public boolean existAll(Object ... instances) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new GetInstancesCountFlow()).putTemporaryData("instances", (Object)instances).execute();
        Long count = (Long)flowContext.checkData("count");
        return count == (long)instances.length;
    }

    @Override
    public boolean existAny(Collection instances) {
        return this.existAny(instances.toArray());
    }

    @Override
    public boolean existAll(Collection instances) {
        return this.existAll(instances.toArray());
    }

    @Override
    public <T> T fetch(Class<T> clazz, long id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.fetch(clazz, entity.id.column, (Object)id);
    }

    @Override
    public <T> T fetch(Class<T> clazz, String field, Object value) {
        List<T> list = this.fetchList(clazz, field, value);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, String fieldName, Object value) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName());
        }
        Property property = entity.getPropertyByFieldNameOrColumnName(fieldName);
        if (null == property) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName() + ",\u5b57\u6bb5:" + fieldName);
        }
        JSONArray array = this.fetchList(entity, property.column, value);
        return array.toJavaList(clazz);
    }

    @Override
    public <T> T fetch(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String convertField = LambdaUtils.resolveLambdaProperty(field);
        return this.fetch(clazz, convertField, value);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String convertField = LambdaUtils.resolveLambdaProperty(field);
        return this.fetchList(clazz, convertField, value);
    }

    @Override
    public JSONObject fetch(String tableName, String columnName, Object value) {
        JSONArray array = this.fetchList(tableName, columnName, value);
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray fetchList(String tableName, String columnName, Object value) {
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == entity) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        JSONArray array = this.fetchList(entity, columnName, value);
        return array;
    }

    @Override
    public JSONArray rawSelect(String selectSQL, Object ... parameters) {
        final JSONArray array = new JSONArray();
        this.quickFlow.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u7528\u6237\u81ea\u5b9a\u4e49\u67e5\u8be2").putTemporaryData("sql", (Object)selectSQL).putTemporaryData("parameters", Arrays.asList(parameters)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                ResultSetMetaData metaData = resultSet.getMetaData();
                String[] columnLables = new String[metaData.getColumnCount()];
                for (int i = 1; i <= columnLables.length; ++i) {
                    columnLables[i - 1] = metaData.getColumnLabel(i);
                }
                while (resultSet.next()) {
                    JSONObject o = new JSONObject();
                    for (int i = 1; i <= columnLables.length; ++i) {
                        o.put(columnLables[i - 1], resultSet.getObject(i));
                    }
                    array.add((Object)o);
                }
            }
        }).execute();
        return array;
    }

    private JSONArray fetchList(Entity entity, String column, Object value) {
        QuickFlowExecutor quickFlowExecutor = null;
        quickFlowExecutor = null == value ? this.quickFlow.startFlow((BusinessFlow)new FetchNullFlow()) : this.quickFlow.startFlow((BusinessFlow)new FetchListFlow());
        FlowContext flowContext = quickFlowExecutor.putTemporaryData("entity", (Object)entity).putTemporaryData("column", (Object)column).putTemporaryData("value", value).execute();
        JSONArray resultSetArray = (JSONArray)flowContext.getData("resultSetArray");
        return resultSetArray;
    }
}

