/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.module.database.dml.domain.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.BeforeExecuteFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.ExecuteFailFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.InsertSqlLogFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.SetPrepareStatementParameterFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteBatchUpdateConnectionFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteBatchUpdateConnectionFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        block19: {
            QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
            String name = (String)flowContext.checkData("name");
            String sql = (String)flowContext.checkData("sql");
            Connection transactionConnection = (Connection)flowContext.getData("transactionConnection");
            flowContext.executeFlowList(new BusinessFlow[]{new BeforeExecuteFlow()});
            this.logger.debug("[\u6279\u5904\u7406\u66f4\u65b0]\u540d\u79f0:{}, \u6267\u884c\u8bed\u53e5:{}", (Object)name, (Object)sql);
            long startTime = System.currentTimeMillis();
            try {
                if (null == transactionConnection) {
                    try (Connection connection = quickDAOConfig.databaseContext.dataSource.getConnection();){
                        this.executeBatchUpdate(connection, flowContext);
                        break block19;
                    }
                }
                this.executeBatchUpdate(transactionConnection, flowContext);
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                flowContext.removeData("getBatchParametersSupplier");
                if (quickDAOConfig.logRecordOption.record && !"\u63d2\u5165SQL\u65e5\u5fd7".equalsIgnoreCase(name)) {
                    long endTime = System.currentTimeMillis();
                    long consumeTime = endTime - startTime;
                    quickDAOConfig.logRecordOption.sqlRecordBuilder.append("[\u66f4\u65b0]\u540d\u79f0:" + name + ",\u8017\u65f6:" + consumeTime + "ms,\u6267\u884c\u8bed\u53e5:" + sql + "\r\n");
                }
            }
        }
    }

    public String name() {
        return "\u6267\u884c\u6279\u5904\u7406\u66f4\u65b0\u8bed\u53e5";
    }

    private void executeBatchUpdate(Connection connection, FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Integer perBatchCount = (Integer)flowContext.getData("perBatchCount", (Object)quickDAOConfig.databaseOption.perBatchCount);
        String sql = (String)flowContext.checkData("sql");
        Integer size = (Integer)flowContext.checkData("size");
        GetBatchParametersSupplier getBatchParametersSupplier = (GetBatchParametersSupplier)flowContext.checkData("getBatchParametersSupplier");
        List<Object> parameters = null;
        int effect = 0;
        flowContext.putTemporaryData("startTime", (Object)System.currentTimeMillis());
        try (PreparedStatement batchPrepareStatement = connection.prepareStatement(sql);){
            for (int i = 0; i < size; i += perBatchCount.intValue()) {
                batchPrepareStatement.clearBatch();
                int end = Math.min(i + perBatchCount, size);
                for (int j = i; j < end; ++j) {
                    parameters = getBatchParametersSupplier.getBatchParameters(j);
                    String currentFormatSQL = ParametersUtil.getFormatSQL(sql, parameters);
                    flowContext.putTemporaryData("formatSQL", (Object)currentFormatSQL);
                    flowContext.startFlow((BusinessFlow)new SetPrepareStatementParameterFlow()).putTemporaryData("preparedStatement", (Object)batchPrepareStatement).putTemporaryData("parameters", parameters).execute();
                    batchPrepareStatement.addBatch();
                }
                effect += this.executeBatch(batchPrepareStatement);
            }
            flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).putTemporaryData("sqlLogType", (Object)1).execute();
        }
        catch (Exception e) {
            flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).next((BusinessFlow)new ExecuteFailFlow()).putTemporaryData("exception", (Object)e).putTemporaryData("sqlLogType", (Object)1).execute();
            throw e;
        }
        finally {
            flowContext.putData("effect", (Object)effect);
        }
    }

    private int executeBatch(PreparedStatement batchPrepareStatement) throws SQLException {
        int[] batches;
        int effect = 0;
        block4: for (int batch : batches = batchPrepareStatement.executeBatch()) {
            switch (batch) {
                case -2: {
                    ++effect;
                    continue block4;
                }
                case -3: {
                    continue block4;
                }
                default: {
                    effect += batch;
                }
            }
        }
        return effect;
    }
}

