/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.SqlLog;
import cn.schoolwow.quickdao.module.database.dml.domain.ManipulationOption;
import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.BeforeExecuteFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.ExecuteFailFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.InsertSqlLogFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.common.SetPrepareStatementParameterFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteUpdateConnectionFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteUpdateConnectionFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new BeforeExecuteFlow()});
        int effect = this.executeUpdate(flowContext);
        flowContext.putData("effect", (Object)effect);
    }

    public String name() {
        return "\u6267\u884c\u66f4\u65b0\u8bed\u53e5";
    }

    private int executeUpdate(FlowContext flowContext) throws SQLException {
        String name = (String)flowContext.checkData("name");
        String sql = (String)flowContext.checkData("sql");
        String formatSQL = (String)flowContext.checkData("formatSQL");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        flowContext.putTemporaryData("startTime", (Object)System.currentTimeMillis());
        String executeSQL = sql;
        int indexOfSemicolon = sql.indexOf(";");
        try {
            int effect = 0;
            if (indexOfSemicolon >= 0 && indexOfSemicolon != sql.length() - 1) {
                StringTokenizer st = new StringTokenizer(sql, ";");
                while (st.hasMoreTokens()) {
                    executeSQL = st.nextToken();
                    effect += this.doExecuteUpdate(executeSQL, flowContext);
                }
            } else {
                effect += this.doExecuteUpdate(executeSQL, flowContext);
            }
            flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).putData("effect", (Object)effect).putTemporaryData("sqlLogType", (Object)1).execute();
            SqlLog sqlLog = (SqlLog)flowContext.checkData("sqlLog");
            this.logger.debug("[\u66f4\u65b0]\u540d\u79f0:{},\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884c\u8bed\u53e5:{}", new Object[]{name, sqlLog.getConsumeTime(), effect, formatSQL});
            if (quickDAOConfig.logRecordOption.record && !"\u63d2\u5165SQL\u65e5\u5fd7".equalsIgnoreCase(name)) {
                quickDAOConfig.logRecordOption.sqlRecordBuilder.append("[\u66f4\u65b0]\u540d\u79f0:" + name + ",\u8017\u65f6:" + sqlLog.getConsumeTime() + "ms,\u5f71\u54cd\u884c\u6570:" + effect + ",\u6267\u884c\u8bed\u53e5:" + formatSQL + "\r\n");
            }
            int n = effect;
            return n;
        }
        catch (Exception e) {
            flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).next((BusinessFlow)new ExecuteFailFlow()).putTemporaryData("exception", (Object)e).putTemporaryData("sqlLogType", (Object)1).execute();
            throw e;
        }
        finally {
            flowContext.removeData("parameters");
        }
    }

    private int doExecuteUpdate(String sql, FlowContext flowContext) throws SQLException {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Connection transactionConnection = (Connection)flowContext.getData("transactionConnection");
        if (null == transactionConnection) {
            try (Connection connection = quickDAOConfig.databaseContext.dataSource.getConnection();){
                int n = this.executeConnectionUpdate(sql, connection, flowContext);
                return n;
            }
        }
        return this.executeConnectionUpdate(sql, transactionConnection, flowContext);
    }

    private int executeConnectionUpdate(String sql, Connection connection, FlowContext flowContext) throws SQLException {
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.getData("manipulationOption");
        boolean returnGeneratedKeys = null != manipulationOption && manipulationOption.returnGeneratedKeys;
        try (PreparedStatement preparedStatement = returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);){
            flowContext.startFlow((BusinessFlow)new SetPrepareStatementParameterFlow()).putTemporaryData("preparedStatement", (Object)preparedStatement).execute();
            int effect = preparedStatement.executeUpdate();
            if (returnGeneratedKeys) {
                this.setReturnGenerateKeys(preparedStatement, flowContext);
            }
            int n = effect;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setReturnGenerateKeys(PreparedStatement preparedStatement, final FlowContext flowContext) throws SQLException {
        ResultSet resultSet;
        block13: {
            DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
            switch (databaseType) {
                case Oracle: {
                    String tableName = (String)flowContext.checkData("tableName");
                    flowContext.getQuickFlow().startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u81ea\u589eid").putTemporaryData("sql", (Object)("select " + tableName + "_seq.currVal from dual")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

                        @Override
                        public void consumeResultSet(ResultSet resultSet) throws Exception {
                            if (resultSet.next()) {
                                flowContext.putData("generateKeys", (Object)resultSet.getString(1));
                            }
                        }
                    }).execute();
                    return;
                }
            }
            resultSet = preparedStatement.getGeneratedKeys();
            Throwable throwable = null;
            try {
                if (resultSet.next()) {
                    flowContext.putData("generateKeys", (Object)resultSet.getString(1));
                }
                if (resultSet == null) return;
                if (throwable == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (resultSet == null) throw throwable3;
                    if (throwable == null) {
                        resultSet.close();
                        throw throwable3;
                    }
                    try {
                        resultSet.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            try {
                resultSet.close();
                return;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                return;
            }
        }
        resultSet.close();
    }
}

