/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor.common;

import cn.schoolwow.quickdao.module.database.dml.domain.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.module.database.dql.parent.domain.QueryContext;
import cn.schoolwow.quickdao.module.database.dql.subCondition.domain.SubQueryOption;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeExecuteFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(BeforeExecuteFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.checkParameterCount(flowContext);
        this.setFormatSQL(flowContext);
    }

    public String name() {
        return "\u6267\u884cSQL\u8bed\u53e5\u4e4b\u524d";
    }

    private void checkParameterCount(FlowContext flowContext) {
        long actualParameterCount;
        GetBatchParametersSupplier getBatchParametersSupplier = (GetBatchParametersSupplier)flowContext.getData("getBatchParametersSupplier");
        if (null != getBatchParametersSupplier) {
            return;
        }
        String name = (String)flowContext.checkData("name");
        String sql = (String)flowContext.checkData("sql");
        List parameters = (List)flowContext.getData("parameters");
        int expectParameterCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++expectParameterCount;
        }
        long l = actualParameterCount = null == parameters ? 0L : (long)parameters.size();
        if (expectParameterCount > 0 && actualParameterCount != (long)expectParameterCount) {
            this.logger.warn("SQL\u8bed\u53e5\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\r\n\u540d\u79f0:{}\r\n\u539f\u59cbSQL:{}\r\n\u53c2\u6570\u5217\u8868:{}", new Object[]{name, sql, parameters});
            QueryContext queryContext = (QueryContext)flowContext.getData("queryContext");
            if (null != queryContext) {
                this.logger.warn("Condition\u67e5\u8be2\u53c2\u6570\u5217\u8868\r\nselect:{}\r\nfrom:{}\r\njoin:{}\r\nwhere:{}\r\nhaving:{}\r\nset:{}\r\n", new Object[]{queryContext.selectParameters, queryContext.fromParameters, queryContext.joinParameters, queryContext.whereParameters, queryContext.havingParameters, queryContext.setParameters});
                if (!queryContext.queryOption.subQueryOptionList.isEmpty()) {
                    StringBuilder builder = new StringBuilder("\u8fde\u8868\u67e5\u8be2\u53c2\u6570\n\n");
                    for (SubQueryOption subQueryOption : queryContext.queryOption.subQueryOptionList) {
                        builder.append("\u8868\u540d:" + subQueryOption.subQueryTableOption.entity.tableName + "\r\n");
                        builder.append("\u522b\u540d:" + subQueryOption.subQueryTableOption.tableAliasName + "\r\n");
                        builder.append("where\u53c2\u6570:" + subQueryOption.subQueryFragmentOption.whereParameterList + "\r\n");
                        builder.append("having\u53c2\u6570:" + subQueryOption.subQueryFragmentOption.havingParameterList + "\r\n");
                    }
                    this.logger.warn(builder.toString());
                }
            }
            throw new IllegalArgumentException("SQL\u8bed\u53e5\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!\u9884\u671f\u4e2a\u6570:" + expectParameterCount + ",\u5b9e\u9645\u4e2a\u6570:" + actualParameterCount);
        }
    }

    private void setFormatSQL(FlowContext flowContext) {
        String sql = (String)flowContext.checkData("sql");
        List parameters = (List)flowContext.getData("parameters");
        if (!sql.contains("?") && null != parameters && !parameters.isEmpty()) {
            parameters = null;
        }
        String formatSQL = ParametersUtil.getFormatSQL(sql, parameters);
        flowContext.putTemporaryData("formatSQL", (Object)formatSQL);
    }
}

