/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor.common;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.SqlLog;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class InsertSqlLogFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setSqlLog(flowContext);
        this.insertSqlLog(flowContext);
    }

    public String name() {
        return "\u63d2\u5165SQL\u65e5\u5fd7";
    }

    private void setSqlLog(FlowContext flowContext) {
        String sql = (String)flowContext.checkData("sql");
        String formatSQL = (String)flowContext.checkData("formatSQL");
        Exception e = (Exception)flowContext.getData("exception");
        List parameters = (List)flowContext.getData("parameters");
        String name = (String)flowContext.checkData("name");
        long startTime = (Long)flowContext.checkData("startTime");
        int sqlLogType = (Integer)flowContext.checkData("sqlLogType");
        Integer effect = (Integer)flowContext.getData("effect");
        long endTime = System.currentTimeMillis();
        long consumeTime = endTime - startTime;
        SqlLog sqlLog = new SqlLog();
        sqlLog.setType(sqlLogType);
        sqlLog.setName(name);
        sqlLog.setConsumeTime(consumeTime);
        sqlLog.setStatement(sql);
        sqlLog.setFormatStatement(formatSQL);
        if (null != parameters && !parameters.isEmpty()) {
            sqlLog.setParameters(parameters.toString());
        }
        sqlLog.setEffect(effect);
        if (null != e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sqlLog.setException(sw.toString());
        }
        flowContext.putData("sqlLog", (Object)sqlLog);
    }

    private void insertSqlLog(FlowContext flowContext) throws InterruptedException {
        Boolean insertSqlLog = (Boolean)flowContext.getData("insertSqlLog");
        if (null != insertSqlLog && !insertSqlLog.booleanValue()) {
            return;
        }
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        SqlLog sqlLog = (SqlLog)flowContext.checkData("sqlLog");
        if (quickDAOConfig.logRecordOption.recordSqlLog) {
            quickDAOConfig.logRecordOption.sqlLogBlockingQueue.offer(sqlLog, 3L, TimeUnit.SECONDS);
        }
    }
}

