/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor.common;

import cn.schoolwow.quickdao.module.database.parent.domain.DatabaseType;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPrepareStatementParameterFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(SetPrepareStatementParameterFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        PreparedStatement preparedStatement = (PreparedStatement)flowContext.checkData("preparedStatement");
        Collection parameters = (Collection)flowContext.getData("parameters");
        if (null == parameters || parameters.isEmpty()) {
            return;
        }
        int parameterIndex = 1;
        for (Object parameter : parameters) {
            if (null == parameter) {
                preparedStatement.setObject(parameterIndex, null);
            } else {
                block31 : switch (parameter.getClass().getName()) {
                    case "byte": {
                        preparedStatement.setByte(parameterIndex, (Byte)parameter);
                        break;
                    }
                    case "[B": {
                        preparedStatement.setBytes(parameterIndex, (byte[])parameter);
                        break;
                    }
                    case "boolean": {
                        boolean value = (Boolean)parameter;
                        preparedStatement.setBoolean(parameterIndex, value);
                        break;
                    }
                    case "short": {
                        preparedStatement.setShort(parameterIndex, (Short)parameter);
                        break;
                    }
                    case "int": {
                        preparedStatement.setInt(parameterIndex, (Integer)parameter);
                        break;
                    }
                    case "float": {
                        preparedStatement.setFloat(parameterIndex, ((Float)parameter).floatValue());
                        break;
                    }
                    case "long": {
                        preparedStatement.setLong(parameterIndex, (Long)parameter);
                        break;
                    }
                    case "double": {
                        preparedStatement.setDouble(parameterIndex, (Double)parameter);
                        break;
                    }
                    case "java.lang.String": {
                        preparedStatement.setString(parameterIndex, (String)parameter);
                        break;
                    }
                    case "java.util.Date": {
                        java.util.Date date = (java.util.Date)parameter;
                        preparedStatement.setDate(parameterIndex, new Date(date.getTime()));
                        break;
                    }
                    case "java.sql.Date": {
                        Date date = (Date)parameter;
                        preparedStatement.setDate(parameterIndex, date);
                        break;
                    }
                    case "java.sql.Time": {
                        Time time = (Time)parameter;
                        preparedStatement.setTime(parameterIndex, time);
                        break;
                    }
                    case "java.sql.Timestamp": {
                        Timestamp timestamp = (Timestamp)parameter;
                        preparedStatement.setTimestamp(parameterIndex, timestamp);
                        break;
                    }
                    case "java.time.LocalDate": {
                        LocalDate localDate = (LocalDate)parameter;
                        switch (databaseType) {
                            case Oracle: {
                                ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
                                Date date = new Date(Date.from(zonedDateTime.toInstant()).getTime());
                                preparedStatement.setObject(parameterIndex, date);
                                break block31;
                            }
                        }
                        preparedStatement.setObject(parameterIndex, localDate);
                        break;
                    }
                    case "java.time.LocalDateTime": {
                        LocalDateTime localDateTime = (LocalDateTime)parameter;
                        switch (databaseType) {
                            case Oracle: {
                                ZoneId zoneId = ZoneId.systemDefault();
                                Instant instant = localDateTime.atZone(zoneId).toInstant();
                                Timestamp timestamp = new Timestamp(instant.toEpochMilli());
                                preparedStatement.setObject(parameterIndex, timestamp);
                                break block31;
                            }
                        }
                        preparedStatement.setObject(parameterIndex, localDateTime);
                        break;
                    }
                    case "java.sql.Array": {
                        preparedStatement.setArray(parameterIndex, (Array)parameter);
                        break;
                    }
                    case "java.math.BigDecimal": {
                        preparedStatement.setBigDecimal(parameterIndex, (BigDecimal)parameter);
                        break;
                    }
                    case "java.sql.Blob": {
                        preparedStatement.setBlob(parameterIndex, (Blob)parameter);
                        break;
                    }
                    case "java.sql.Clob": {
                        preparedStatement.setClob(parameterIndex, (Clob)parameter);
                        break;
                    }
                    case "java.sql.NClob": {
                        preparedStatement.setNClob(parameterIndex, (NClob)parameter);
                        break;
                    }
                    case "java.sql.Ref": {
                        preparedStatement.setRef(parameterIndex, (Ref)parameter);
                        break;
                    }
                    case "java.net.URL": {
                        preparedStatement.setURL(parameterIndex, (URL)parameter);
                        break;
                    }
                    case "java.sql.RowId": {
                        preparedStatement.setRowId(parameterIndex, (RowId)parameter);
                        break;
                    }
                    case "java.sql.SQLXML": {
                        preparedStatement.setSQLXML(parameterIndex, (SQLXML)parameter);
                        break;
                    }
                    case "java.io.InputStream": {
                        preparedStatement.setBinaryStream(parameterIndex, (InputStream)parameter);
                        break;
                    }
                    case "java.io.Reader": {
                        preparedStatement.setCharacterStream(parameterIndex, (Reader)parameter);
                        break;
                    }
                    case "com.alibaba.fastjson.JSONObject": {
                        JSONObject o = (JSONObject)parameter;
                        String jsonString = o.toJSONString();
                        preparedStatement.setObject(parameterIndex, jsonString);
                        break;
                    }
                    case "com.alibaba.fastjson.JSONArray": {
                        JSONArray o = (JSONArray)parameter;
                        String jsonString = o.toJSONString();
                        preparedStatement.setObject(parameterIndex, jsonString);
                        break;
                    }
                    default: {
                        try {
                            preparedStatement.setObject(parameterIndex, parameter);
                            break;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.logger.trace("\u8bbe\u7f6e\u53c2\u6570,\u7d22\u5f15:{},\u503c:{}", (Object)parameterIndex, parameter);
            ++parameterIndex;
        }
    }

    public String name() {
        return "\u8bbe\u7f6eSQL\u8bed\u53e5\u53c2\u6570";
    }
}

