/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.transaction.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.module.database.dml.kit.DatabaseManipulationImpl;
import cn.schoolwow.quickdao.module.database.transaction.kit.TransactionOperation;
import cn.schoolwow.quickdao.module.database.transaction.kit.TransactionOperationImpl;
import cn.schoolwow.quickdao.module.parent.flow.QuickDAOTryCatchFinallyHandler;
import cn.schoolwow.quickdao.module.query.kit.QueryOperation;
import cn.schoolwow.quickdao.module.query.kit.QueryOperationImpl;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public class TransactionInvocationHandler
implements InvocationHandler {
    private Connection transactionConnection;
    private QuickFlow quickFlow;
    private QuickDAOConfig quickDAOConfig;
    private QueryOperation queryOperation;
    private TransactionOperation transactionOperation;

    public TransactionInvocationHandler(QuickDAOConfig quickDAOConfig) {
        try {
            this.quickFlow = this.setTransactionConnection(quickDAOConfig);
            this.quickDAOConfig = quickDAOConfig;
            this.queryOperation = new QueryOperationImpl(this.quickFlow, quickDAOConfig);
            this.transactionOperation = new TransactionOperationImpl(this.transactionConnection);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName;
        switch (interfaceName = method.getDeclaringClass().getSimpleName()) {
            case "Closeable": 
            case "TransactionOperation": {
                return method.invoke((Object)this.transactionOperation, args);
            }
            case "Object": 
            case "DatabaseDAO": 
            case "DatabaseManipulation": {
                return method.invoke((Object)new DatabaseManipulationImpl(this.quickFlow, this.quickDAOConfig), args);
            }
            case "QueryOperation": {
                return method.invoke((Object)this.queryOperation, args);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\u8c03\u7528!\u63a5\u53e3\u540d:" + interfaceName + ",\u65b9\u6cd5:" + method);
    }

    private QuickFlow setTransactionConnection(QuickDAOConfig quickDAOConfig) throws SQLException {
        this.transactionConnection = quickDAOConfig.databaseContext.dataSource.getConnection();
        this.transactionConnection.setAutoCommit(false);
        QuickFlow quickFlow = QuickFlowBuilder.newInstance().printTrace(quickDAOConfig.logRecordOption.recordFlowLog).tryCatchFinallyHandler((TryCatchFinallyHandler)new QuickDAOTryCatchFinallyHandler(this.transactionConnection, quickDAOConfig));
        return quickFlow;
    }
}

