/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.database;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import javax.sql.DataSource;

public class CheckDataSourceFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataSource dataSource = (DataSource)flowContext.checkData("dataSource");
        if (!(dataSource instanceof HikariDataSource)) {
            flowContext.broken("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u7c7b\u578b!\u7c7b\u540d:" + dataSource.getClass().getName());
        }
        List databaseProviderList = (List)flowContext.checkData("databaseProviderList");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
        String jdbcUrl = hikariDataSource.getJdbcUrl();
        for (DatabaseProvider databaseProvider : databaseProviderList) {
            if (!jdbcUrl.contains("jdbc:" + databaseProvider.name())) continue;
            quickDAOConfig.databaseContext.databaseProvider = databaseProvider;
            break;
        }
        if (null == quickDAOConfig.databaseContext.databaseProvider) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!jdbcUrl:" + jdbcUrl);
        }
        flowContext.putTemporaryData("jdbcUrl", (Object)jdbcUrl);
        flowContext.putTemporaryData("databaseType", (Object)quickDAOConfig.databaseContext.databaseProvider.getDatabaseType());
        flowContext.putTemporaryData("hikariDataSource", (Object)hikariDataSource);
    }

    public String name() {
        return "\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u6c60";
    }
}

