/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.DatabaseUpgrade;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.SqlLog;
import cn.schoolwow.quickdao.module.database.ddl.service.table.action.CreateTableFlow;
import cn.schoolwow.quickdao.module.database.ddl.service.table.has.HasTableFlow;
import cn.schoolwow.quickdao.module.database.dml.domain.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.module.database.dml.domain.ManipulationOption;
import cn.schoolwow.quickdao.module.database.dml.flow.instance.insert.common.SetInsertInstanceParameterFlow;
import cn.schoolwow.quickdao.module.database.dml.flow.instance.insert.common.SetInsertInstanceStatementFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickdao.module.initial.flow.table.CompareAndCreateColumnFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LogRecordFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.createLogTable(flowContext);
        this.handleSqlLog(flowContext);
    }

    public String name() {
        return "\u521b\u5efaSQL\u65e5\u5fd7\u8bb0\u5f55";
    }

    private void createLogTable(FlowContext flowContext) {
        String[] sqlLogClassNames;
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        for (String sqlLogClassName : sqlLogClassNames = new String[]{DatabaseUpgrade.class.getName(), SqlLog.class.getName()}) {
            Entity entity = quickDAOConfig.databaseContext.entityMap.get(sqlLogClassName);
            if (null == entity) {
                throw new IllegalArgumentException("\u65e5\u5fd7\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728!\u7c7b\u540d:" + sqlLogClassName);
            }
            boolean hasResult = (Boolean)flowContext.getQuickFlow().startFlow((BusinessFlow)new HasTableFlow()).putTemporaryData("tableName", (Object)entity.tableName).putTemporaryData("insertSqlLog", (Object)false).execute().checkData("hasResult");
            if (!hasResult) {
                flowContext.getQuickFlow().startFlow((BusinessFlow)new CreateTableFlow()).putData("entity", (Object)entity).putData("insertSqlLog", (Object)false).execute();
                continue;
            }
            flowContext.getQuickFlow().startFlow((BusinessFlow)new CompareAndCreateColumnFlow()).putData("entity", (Object)entity).putData("insertSqlLog", (Object)false).execute();
        }
    }

    private void handleSqlLog(final FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Entity entity = quickDAOConfig.databaseContext.entityMap.get(SqlLog.class.getName());
        if (null == entity) {
            throw new IllegalArgumentException("SqlLog\u65e5\u5fd7\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728!");
        }
        ManipulationOption manipulationOption = new ManipulationOption();
        manipulationOption.returnGeneratedKeys = false;
        quickDAOConfig.asyncThreadPool.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        List<SqlLog> sqlLogList;
                        if ((sqlLogList = this.getSqlLogInstances(quickDAOConfig)).isEmpty()) {
                            continue;
                        }
                        flowContext.startFlow("\u7ebf\u7a0b\u5f02\u6b65\u6279\u5904\u7406\u63d2\u5165SQL\u65e5\u5fd7").putTemporaryData("insertSqlLog", (Object)false).putTemporaryData("entity", (Object)entity).putTemporaryData("manipulationOption", (Object)manipulationOption).putTemporaryData("name", (Object)"\u6279\u5904\u7406\u63d2\u5165SQL\u65e5\u5fd7").putTemporaryData("size", (Object)sqlLogList.size()).putTemporaryData("getBatchParametersSupplier", (Object)new GetBatchParametersSupplier(){

                            @Override
                            public List<Object> getBatchParameters(Integer index) throws Exception {
                                SqlLog sqlLog = (SqlLog)sqlLogList.get(index);
                                flowContext.putTemporaryData("instance", (Object)sqlLog);
                                flowContext.executeFlowList(new BusinessFlow[]{new SetInsertInstanceParameterFlow()});
                                List parameters = (List)flowContext.getData("parameters");
                                return parameters;
                            }
                        }).next((BusinessFlow)new SetInsertInstanceStatementFlow()).next((BusinessFlow)new ExecuteBatchUpdateConnectionFlow()).execute();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
    }

    private List<SqlLog> getSqlLogInstances(QuickDAOConfig quickDAOConfig) throws InterruptedException {
        long timeout = 3000L;
        long startTime = System.currentTimeMillis();
        ArrayList<SqlLog> sqlLogList = new ArrayList<SqlLog>();
        SqlLog sqlLog = quickDAOConfig.logRecordOption.sqlLogBlockingQueue.poll(3L, TimeUnit.SECONDS);
        while (sqlLog != null && System.currentTimeMillis() - startTime < timeout && sqlLogList.size() < 1000) {
            sqlLogList.add(sqlLog);
            sqlLog = quickDAOConfig.logRecordOption.sqlLogBlockingQueue.poll(3L, TimeUnit.SECONDS);
        }
        return sqlLogList;
    }
}

