/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.operation.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.domain.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickdao.module.database.dml.domain.ManipulationOption;
import cn.schoolwow.quickdao.module.database.dml.service.instance.insert.InsertInstanceArrayCompositeBusiness;
import cn.schoolwow.quickdao.module.database.transaction.kit.TransactionInvocationHandler;
import cn.schoolwow.quickdao.module.operation.kit.DAOOperation;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class DAOOperationImpl
implements DAOOperation {
    private final QuickDAOConfig quickDAOConfig;

    public DAOOperationImpl(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public Transaction startTransaction() {
        TransactionInvocationHandler transactionInvocationHandler = new TransactionInvocationHandler(this.quickDAOConfig);
        Transaction transactionProxy = (Transaction)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Transaction.class}, (InvocationHandler)transactionInvocationHandler);
        return transactionProxy;
    }

    @Override
    public void startTransaction(Consumer<Transaction> transactionConsumer) {
        Transaction transaction = this.startTransaction();
        Connection connection = transaction.getTransactionConnection();
        try {
            transactionConsumer.accept(transaction);
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLRuntimeException(e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.quickDAOConfig.databaseContext.dataSource;
    }

    @Override
    public Map<String, Entity> getEntityMap() {
        return this.quickDAOConfig.databaseContext.entityMap;
    }

    @Override
    public Entity getEntity(Class clazz) {
        return this.quickDAOConfig.databaseContext.entityMap.values().stream().filter(entity -> entity.clazz.getName().equalsIgnoreCase(clazz.getName())).findFirst().orElse(null);
    }

    @Override
    public Entity getEntity(String tableName) {
        return this.quickDAOConfig.databaseContext.entityMap.values().stream().filter(entity -> entity.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
    }

    @Override
    public Property getEntityProperty(Class clazz, String fieldName) {
        Entity entity = this.getEntity(clazz);
        if (null == entity) {
            throw new IllegalArgumentException("\u672a\u626b\u63cf\u5230\u5b9e\u4f53\u7c7b!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName());
        }
        return entity.getPropertyByFieldNameOrColumnName(fieldName);
    }

    @Override
    public DatabaseProvider getDatabaseProvider() {
        return this.quickDAOConfig.databaseContext.databaseProvider;
    }

    @Override
    public QuickDAOConfig getQuickDAOConfig() {
        return this.quickDAOConfig;
    }

    @Override
    public void recordFlowLog(boolean recordFlowLog) {
        this.quickDAOConfig.logRecordOption.recordFlowLog = recordFlowLog;
    }

    @Override
    public void recordSqlLog(boolean recordSqlLog) {
        this.quickDAOConfig.logRecordOption.recordSqlLog = recordSqlLog;
    }

    @Override
    public void startRecord() {
        this.quickDAOConfig.logRecordOption.record = true;
    }

    @Override
    public String stopRecord() {
        this.quickDAOConfig.logRecordOption.record = false;
        String sqlRecord = this.quickDAOConfig.logRecordOption.sqlRecordBuilder.toString();
        this.quickDAOConfig.logRecordOption.sqlRecordBuilder.setLength(0);
        return sqlRecord;
    }

    @Override
    public <T> T log(Class<T> logEntity) {
        return this.logMap("#SINGLE_INSTANCE#", logEntity);
    }

    @Override
    public <T> T logIfExist(Class<T> logEntity) {
        return this.logMapIfExist("#SINGLE_INSTANCE#", logEntity);
    }

    @Override
    public <T> T logMapIfExist(String uniqueKey, Class<T> logEntity) {
        if (null == uniqueKey || uniqueKey.isEmpty()) {
            throw new IllegalArgumentException("\u552f\u4e00\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if ((classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName())).containsKey(uniqueKey)) {
                Object logInstance = classNameLogInstance.get(uniqueKey);
                return (T)logInstance;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> logMap(Class<T> logEntity) {
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if (null == (classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName()))) {
                return null;
            }
            ArrayList instanceList = new ArrayList();
            for (Object instance : classNameLogInstance.values()) {
                instanceList.add(instance);
            }
            return instanceList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T logMap(String uniqueKey, Class<T> logEntity) {
        if (null == uniqueKey || uniqueKey.isEmpty()) {
            throw new IllegalArgumentException("\u552f\u4e00\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if (!(classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName())).containsKey(uniqueKey)) {
                classNameLogInstance.put(uniqueKey, logEntity.newInstance());
            }
            Object logInstance = classNameLogInstance.get(uniqueKey);
            return (T)logInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearLog() {
        Map<String, Map<String, Object>> classNameLogInstanceMap = this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get();
        if (null != classNameLogInstanceMap) {
            classNameLogInstanceMap.clear();
        }
    }

    @Override
    public void insertLog() {
        Map<Object, Object> classNameLogInstanceMap;
        if (null == this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get()) {
            classNameLogInstanceMap = new ConcurrentHashMap();
            this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
        }
        if (null == (classNameLogInstanceMap = this.quickDAOConfig.logRecordOption.classNameLogInstanceMapThreadLocal.get())) {
            return;
        }
        Collection<Object> logInstanceMapCollection = classNameLogInstanceMap.values();
        for (Map map : logInstanceMapCollection) {
            Collection logInstances = map.values();
            this.quickDAOConfig.quickFlow.startFlow((CompositeBusinessFlow)new InsertInstanceArrayCompositeBusiness()).putTemporaryData("instances", (Object)logInstances.toArray(new Object[0])).putTemporaryData("manipulationOption", (Object)new ManipulationOption()).execute();
        }
        classNameLogInstanceMap.clear();
    }
}

