/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.parent.flow;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAOTryCatchFinallyHandler
implements TryCatchFinallyHandler {
    private Logger logger = LoggerFactory.getLogger(QuickDAOTryCatchFinallyHandler.class);
    private Connection transactionConnection;
    private QuickDAOConfig quickDAOConfig;

    public QuickDAOTryCatchFinallyHandler(Connection transactionConnection, QuickDAOConfig quickDAOConfig) {
        this.transactionConnection = transactionConnection;
        this.quickDAOConfig = quickDAOConfig;
    }

    public void handleTry(FlowContext flowContext) throws Exception {
        flowContext.printTrace(this.quickDAOConfig.logRecordOption.recordFlowLog);
        flowContext.putData("transactionConnection", (Object)this.transactionConnection);
        flowContext.putData("quickDAOConfig", (Object)this.quickDAOConfig);
        flowContext.putData("databaseType", (Object)this.quickDAOConfig.databaseContext.databaseProvider.getDatabaseType());
        flowContext.putData("databaseProvider", (Object)this.quickDAOConfig.databaseContext.databaseProvider);
    }

    public void handleException(FlowContext flowContext, Exception e) {
        e.printStackTrace();
    }

    public void handleFinally(FlowContext flowContext) {
        if (null != flowContext.getFlowException() || this.quickDAOConfig.logRecordOption.recordFlowLog) {
            this.logger.info("\r\n" + flowContext.getFlowTrace());
        }
    }

    public String name() {
        return "QuickDAO\u5168\u5c40\u4e8b\u4ef6";
    }
}

