/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.parent.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.module.database.dcl.kit.DatabaseControl;
import cn.schoolwow.quickdao.module.database.dcl.kit.DatabaseControlImpl;
import cn.schoolwow.quickdao.module.database.ddl.kit.DatabaseDefinition;
import cn.schoolwow.quickdao.module.database.ddl.kit.DatabaseDefinitionImpl;
import cn.schoolwow.quickdao.module.database.dml.kit.DatabaseManipulationImpl;
import cn.schoolwow.quickdao.module.database.dql.query.kit.DatabaseQuery;
import cn.schoolwow.quickdao.module.database.dql.query.kit.DatabaseQueryImpl;
import cn.schoolwow.quickdao.module.operation.kit.DAOOperation;
import cn.schoolwow.quickdao.module.operation.kit.DAOOperationImpl;
import cn.schoolwow.quickdao.module.query.kit.QueryOperation;
import cn.schoolwow.quickdao.module.query.kit.QueryOperationImpl;
import cn.schoolwow.quickflow.QuickFlow;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class DAOInvocationHandler
implements InvocationHandler {
    private DatabaseControl databaseControl;
    private DatabaseDefinition databaseDefinition;
    private DatabaseQuery databaseQuery;
    private QueryOperation queryOperation;
    private DAOOperation daoOperation;
    private QuickFlow quickFlow;
    private QuickDAOConfig quickDAOConfig;

    public DAOInvocationHandler(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        this.quickFlow = quickFlow;
        this.quickDAOConfig = quickDAOConfig;
        this.databaseControl = new DatabaseControlImpl(quickFlow, quickDAOConfig);
        this.databaseDefinition = new DatabaseDefinitionImpl(quickFlow, quickDAOConfig);
        this.databaseQuery = new DatabaseQueryImpl(quickFlow, quickDAOConfig);
        this.queryOperation = new QueryOperationImpl(quickFlow, quickDAOConfig);
        this.daoOperation = new DAOOperationImpl(quickDAOConfig);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        Object result = null;
        switch (interfaceName) {
            case "DatabaseControl": {
                result = method.invoke((Object)this.databaseControl, args);
                break;
            }
            case "DatabaseDefinition": {
                result = method.invoke((Object)this.databaseDefinition, args);
                break;
            }
            case "DatabaseManipulation": {
                result = method.invoke((Object)new DatabaseManipulationImpl(this.quickFlow, this.quickDAOConfig), args);
                break;
            }
            case "DatabaseQuery": {
                result = method.invoke((Object)this.databaseQuery, args);
                break;
            }
            case "QueryOperation": {
                result = method.invoke((Object)this.queryOperation, args);
                break;
            }
            case "DAOOperation": {
                result = method.invoke((Object)this.daoOperation, args);
                break;
            }
            default: {
                throw new IllegalAccessError("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + method.getName());
            }
        }
        return result;
    }
}

