/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.domain.entity.PropertyOption;
import cn.schoolwow.quickdao.domain.util.SynchronizeTableStructureOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOUtils {
    private static Logger logger = LoggerFactory.getLogger(DAOUtils.class);

    public static void synchronizeTableStructure(SynchronizeTableStructureOption synchronizeTableStructureOption) {
        if (null == synchronizeTableStructureOption.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == synchronizeTableStructureOption.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        List<Object> sourceEntityList = new ArrayList();
        if (null == synchronizeTableStructureOption.tableNames || synchronizeTableStructureOption.tableNames.length == 0) {
            sourceEntityList = synchronizeTableStructureOption.source.getDatabaseEntityList();
        } else {
            for (String tableName : synchronizeTableStructureOption.tableNames) {
                Entity entity = synchronizeTableStructureOption.source.getDatabaseEntity(tableName);
                if (null == entity) {
                    logger.warn("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
                    continue;
                }
                sourceEntityList.add(entity);
            }
        }
        ArrayList<Entity> addEntityList = new ArrayList<Entity>();
        ArrayList<Property> addPropertyList = new ArrayList<Property>();
        HashMap<Property, Property> updatePropertyMap = new HashMap<Property, Property>();
        for (Entity entity : sourceEntityList) {
            Entity targetEntity = synchronizeTableStructureOption.target.getDatabaseEntity(entity.tableName);
            if (null == targetEntity) {
                addEntityList.add(entity);
                continue;
            }
            List<Property> sourcePropertyList = entity.properties;
            for (Property sourceProperty : sourcePropertyList) {
                Property targetProperty = targetEntity.properties.stream().filter(property -> property.column.equalsIgnoreCase(sourceProperty.column)).findFirst().orElse(null);
                if (null == targetProperty) {
                    addPropertyList.add(sourceProperty);
                    continue;
                }
                if (!synchronizeTableStructureOption.diffPropertyPredicate.test(sourceProperty, targetProperty)) continue;
                updatePropertyMap.put(sourceProperty, targetProperty);
            }
        }
        for (Entity entity : addEntityList) {
            if (null != synchronizeTableStructureOption.createTablePredicate && !synchronizeTableStructureOption.createTablePredicate.test(entity)) continue;
            synchronizeTableStructureOption.target.create(entity);
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.create(entity);
        }
        for (Property property2 : addPropertyList) {
            if (null != synchronizeTableStructureOption.createPropertyPredicate && !synchronizeTableStructureOption.createPropertyPredicate.test(property2)) continue;
            synchronizeTableStructureOption.target.createColumn(property2.entity.tableName, property2);
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.createColumn(property2.entity.tableName, property2);
        }
        Set propertyEntrySet = updatePropertyMap.entrySet();
        for (Map.Entry entry : propertyEntrySet) {
            if (null != synchronizeTableStructureOption.updatePropertyPredicate && !synchronizeTableStructureOption.updatePropertyPredicate.test((Property)entry.getKey(), (Property)entry.getValue())) continue;
            synchronizeTableStructureOption.target.alterColumn(((Property)entry.getKey()).entity.tableName, (PropertyOption)entry.getKey());
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.alterColumn(((Property)entry.getKey()).entity.tableName, (PropertyOption)entry.getKey());
        }
    }
}

