/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.entity;

import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Entity
implements Serializable,
Cloneable {
    public transient Class clazz;
    public String tableName;
    public String comment;
    public Property id;
    public List<IndexField> indexFieldList = new ArrayList<IndexField>();
    public List<Property> properties = new ArrayList<Property>();
    public List<Property> foreignKeyProperties = new ArrayList<Property>();
    public Map<String, List<String>> compositeFieldMap = new HashMap<String, List<String>>();
    public List<Property> uniqueProperties = new ArrayList<Property>();

    public String getColumnNameByFieldName(String field) {
        Property property = this.getPropertyByFieldNameOrColumnName(field);
        return null == property ? field : property.column;
    }

    public IndexField getIndexFieldByIndexName(String indexName) {
        for (IndexField indexField : this.indexFieldList) {
            if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
            return indexField;
        }
        return null;
    }

    public Property getPropertyByFieldNameOrColumnName(String fieldName) {
        if (null == fieldName || fieldName.isEmpty()) {
            return null;
        }
        for (Property property : this.properties) {
            if (!fieldName.equalsIgnoreCase(property.name) && !fieldName.equalsIgnoreCase(property.column)) continue;
            return property;
        }
        return null;
    }

    public String getCompositeFieldName(String className) {
        if (!this.compositeFieldMap.containsKey(className)) {
            return null;
        }
        List<String> fieldNameList = this.compositeFieldMap.get(className);
        if (fieldNameList.isEmpty()) {
            return null;
        }
        if (fieldNameList.size() == 1) {
            return fieldNameList.get(0);
        }
        throw new IllegalArgumentException("\u7c7b[" + this.clazz.getName() + "]\u5b58\u5728[" + fieldNameList.size() + "]\u4e2a\u7c7b\u578b\u4e3a[" + className + "]\u7684\u6210\u5458\u53d8\u91cf!\u8bf7\u624b\u52a8\u6307\u5b9a\u9700\u8981\u5173\u8054\u7684\u5b9e\u4f53\u7c7b\u6210\u5458\u53d8\u91cf!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.tableName.equals(entity.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    public void copyTransientField(Entity target) {
        int i;
        this.clazz = target.clazz;
        if (null != this.id) {
            this.id.copyTransientField(target.id);
        }
        for (i = 0; i < this.indexFieldList.size(); ++i) {
            this.indexFieldList.get(i).copyTransientField(target.indexFieldList.get(i));
        }
        if (null != this.properties) {
            for (i = 0; i < this.properties.size(); ++i) {
                this.properties.get(i).copyTransientField(target.properties.get(i));
            }
        }
        for (i = 0; i < this.foreignKeyProperties.size(); ++i) {
            this.foreignKeyProperties.get(i).copyTransientField(target.foreignKeyProperties.get(i));
        }
        for (i = 0; i < this.uniqueProperties.size(); ++i) {
            this.uniqueProperties.get(i).copyTransientField(target.uniqueProperties.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Entity clone() {
        ByteArrayInputStream bais = null;
        try {
            Entity entity;
            Throwable throwable;
            ByteArrayOutputStream baos;
            block24: {
                block25: {
                    baos = new ByteArrayOutputStream();
                    throwable = null;
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(this);
                    oos.close();
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    Entity entity2 = (Entity)ois.readObject();
                    entity2.copyTransientField(this);
                    bais.close();
                    entity = entity2;
                    if (baos == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                baos.close();
            }
            return entity;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (baos != null) {
                            if (throwable != null) {
                                try {
                                    baos.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                baos.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (null != bais) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public String toString() {
        return "\n{\n\u5b9e\u4f53\u7c7b\u7c7b\u540d:" + (null == this.clazz ? "" : this.clazz.getName()) + "\n\u539f\u59cb\u8868\u540d:" + this.tableName + "\n\u8868\u6ce8\u91ca:" + this.comment + "\nId\u5c5e\u6027:" + (null == this.id ? "\u65e0" : this.id.column) + "\n\u7d22\u5f15\u5217\u8868:" + this.indexFieldList + "\n\u5b57\u6bb5\u5217\u8868:" + this.properties + "\n\u5916\u952e\u7ea6\u675f\u5217\u8868:" + this.foreignKeyProperties + "\n\u5b9e\u4f53\u7c7b\u6210\u5458\u53d8\u91cf:" + this.compositeFieldMap + "\n\u8bb0\u5f55\u552f\u4e00\u5b57\u6bb5\u5217\u8868:" + this.uniqueProperties + "\n}\n";
    }
}

