/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;

public class OracleDatabaseProvider
implements DatabaseProvider {
    @Override
    public String name() {
        return "oracle";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.Oracle;
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public String convertJavaTypeToColumnType(String javaType) {
        switch (javaType) {
            case "char": 
            case "java.lang.Character": {
                return "CHAR";
            }
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": {
                return "INTEGER";
            }
            case "float": 
            case "java.lang.Float": {
                return "BINARY_FLOAT";
            }
            case "long": 
            case "java.lang.Long": {
                return "INTEGER";
            }
            case "double": 
            case "java.lang.Double": {
                return "BINARY_DOUBLE";
            }
            case "java.lang.String": {
                return "VARCHAR2(255)";
            }
            case "java.util.Date": {
                return "TIMESTAMP";
            }
            case "java.sql.Date": {
                return "DATE";
            }
            case "java.sql.Timestamp": {
                return "TIMESTAMP";
            }
            case "java.time.LocalDate": {
                return "DATE";
            }
            case "java.time.LocalDateTime": {
                return "DATETIME";
            }
            case "java.math.BigDecimal": {
                return "INTEGER";
            }
            case "java.sql.Blob": {
                return "BLOB";
            }
            case "java.sql.Clob": {
                return "CLOB";
            }
            case "java.sql.NClob": {
                return "NCLOB";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362java\u6570\u636e\u7c7b\u578b[" + javaType + "]\u4e3a\u6570\u636e\u5e93\u7c7b\u578b");
    }

    @Override
    public String convertColumnTypeToJavaType(String columnType) {
        String rawColumnType = columnType;
        if (columnType.contains("(")) {
            columnType = columnType.substring(0, columnType.indexOf("("));
        }
        switch (columnType = columnType.trim().toUpperCase()) {
            case "CHAR": {
                return "String";
            }
            case "INTEGER": {
                return "Integer";
            }
            case "BINARY_FLOAT": {
                return "Float";
            }
            case "VARCHAR2": {
                return "String";
            }
            case "DATE": {
                return "java.time.LocalDate";
            }
            case "TIMESTAMP": {
                return "java.sql.Timestamp";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362\u6570\u636e\u5e93\u7c7b\u578b[" + rawColumnType + "]\u4e3ajava\u6570\u636e\u7c7b\u578b");
    }
}

