/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;

public class PostgresDatabaseProvider
implements DatabaseProvider {
    @Override
    public String name() {
        return "postgresql";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.Postgresql;
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public String convertJavaTypeToColumnType(String javaType) {
        switch (javaType) {
            case "byte": 
            case "java.lang.Byte": {
                return "BOOLEAN";
            }
            case "[B": {
                return "BIT";
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return "BOOLEAN";
            }
            case "char": {
                return "CHAR";
            }
            case "java.lang.Character": {
                return "CHARACTER";
            }
            case "short": 
            case "java.lang.Short": {
                return "SMALLINT";
            }
            case "int": {
                return "INT4";
            }
            case "java.lang.Integer": {
                return "INTEGER";
            }
            case "float": 
            case "java.lang.Float": {
                return "FLOAT4";
            }
            case "long": 
            case "java.lang.Long": {
                return "INT8";
            }
            case "double": 
            case "java.lang.Double": {
                return "FLOAT8";
            }
            case "java.lang.String": {
                return "VARCHAR(255)";
            }
            case "java.util.Date": {
                return "TIMESTAMP";
            }
            case "java.sql.Date": {
                return "DATE";
            }
            case "java.sql.Time": {
                return "TIME";
            }
            case "java.sql.Timestamp": {
                return "TIMESTAMP";
            }
            case "java.time.LocalDate": {
                return "DATE";
            }
            case "java.time.LocalDateTime": {
                return "TIMESTAMP";
            }
            case "java.math.BigDecimal": {
                return "DECIMAL";
            }
            case "java.sql.Blob": {
                return "TEXT";
            }
            case "java.sql.Clob": {
                return "TEXT";
            }
            case "java.sql.NClob": {
                return "TEXT";
            }
            case "java.io.InputStream": 
            case "java.io.Reader": {
                return "TEXT";
            }
            case "com.alibaba.fastjson.JSONObject": 
            case "com.alibaba.fastjson.JSONArray": {
                return "JSONB";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362java\u6570\u636e\u7c7b\u578b[" + javaType + "]\u4e3a\u6570\u636e\u5e93\u7c7b\u578b");
    }

    @Override
    public String convertColumnTypeToJavaType(String columnType) {
        String rawColumnType = columnType;
        if (columnType.contains("(")) {
            columnType = columnType.substring(0, columnType.indexOf("("));
        }
        switch (columnType = columnType.trim().toUpperCase()) {
            case "BOOL": 
            case "BOOLEAN": {
                return "Boolean";
            }
            case "CHAR": {
                return "char";
            }
            case "CHARACTER": {
                return "Character";
            }
            case "INT4": {
                return "int";
            }
            case "INTEGER": {
                return "Integer";
            }
            case "INT8": {
                return "Long";
            }
            case "FLOAT4": {
                return "Float";
            }
            case "FLOAT8": {
                return "Double";
            }
            case "BIT": {
                return "[B";
            }
            case "VARCHAR": {
                return "String";
            }
            case "BPCHAR": {
                return "String";
            }
            case "TIMESTAMP": {
                return "java.time.LocalDateTime";
            }
            case "DATE": {
                return "java.time.LocalDate";
            }
            case "TIME": {
                return "java.sql.Time";
            }
            case "DECIMAL": {
                return "java.math.BigDecimal";
            }
            case "TEXT": {
                return "String";
            }
            case "JSONB": {
                return "com.alibaba.fastjson.JSONObject";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362\u6570\u636e\u5e93\u7c7b\u578b[" + rawColumnType + "]\u4e3ajava\u6570\u636e\u7c7b\u578b");
    }
}

