/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;

public class SQLServerDatabaseProvider
implements DatabaseProvider {
    @Override
    public String name() {
        return "sqlserver";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLServer;
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public String convertJavaTypeToColumnType(String javaType) {
        switch (javaType) {
            case "byte": 
            case "java.lang.Byte": {
                return "TINYINT";
            }
            case "[B": {
                return "BINARY";
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return "TINYINT";
            }
            case "char": 
            case "java.lang.Character": {
                return "TINYINT";
            }
            case "short": 
            case "java.lang.Short": {
                return "SMALLINT";
            }
            case "int": {
                return "INT";
            }
            case "java.lang.Integer": {
                return "INTEGER(11)";
            }
            case "float": 
            case "java.lang.Float": {
                return "REAL";
            }
            case "long": 
            case "java.lang.Long": {
                return "BIGINT";
            }
            case "double": 
            case "java.lang.Double": {
                return "FLOAT";
            }
            case "java.lang.String": {
                return "VARCHAR(255)";
            }
            case "java.util.Date": {
                return "DATETIME";
            }
            case "java.sql.Date": {
                return "DATE";
            }
            case "java.sql.Time": {
                return "TIME";
            }
            case "java.sql.Timestamp": {
                return "TIMESTAMP";
            }
            case "java.time.LocalDate": {
                return "DATE";
            }
            case "java.time.LocalDateTime": {
                return "DATETIME";
            }
            case "java.math.BigDecimal": {
                return "DECIMAL";
            }
            case "java.sql.Blob": {
                return "BINARY";
            }
            case "java.sql.Clob": {
                return "TEXT";
            }
            case "java.sql.NClob": {
                return "TEXT";
            }
            case "java.io.InputStream": 
            case "java.io.Reader": {
                return "TEXT";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362java\u6570\u636e\u7c7b\u578b[" + javaType + "]\u4e3a\u6570\u636e\u5e93\u7c7b\u578b");
    }

    @Override
    public String convertColumnTypeToJavaType(String columnType) {
        String rawColumnType = columnType;
        if (columnType.contains("(")) {
            columnType = columnType.substring(0, columnType.indexOf("("));
        }
        switch (columnType = columnType.trim().toUpperCase()) {
            case "TINYINT": {
                return "Byte";
            }
            case "INT": {
                return "int";
            }
            case "INTEGER": {
                return "INTEGER(11)";
            }
            case "BIGINT": {
                return "Long";
            }
            case "REAL": {
                return "Float";
            }
            case "FLOAT": {
                return "Double";
            }
            case "VARCHAR": {
                return "String";
            }
            case "DATETIME": {
                return "java.time.LocalDateTime";
            }
            case "DATE": {
                return "java.time.LocalDate";
            }
            case "TIME": {
                return "java.sql.Time";
            }
            case "DECIMAL": {
                return "java.math.BigDecimal";
            }
            case "BINARY": {
                return "java.sql.Blob";
            }
            case "TEXT": {
                return "String";
            }
        }
        throw new IllegalArgumentException("\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362\u6570\u636e\u5e93\u7c7b\u578b[" + rawColumnType + "]\u4e3ajava\u6570\u636e\u7c7b\u578b");
    }
}

