/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dcl.kit;

import cn.schoolwow.quickdao.domain.database.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.database.dcl.GrantOption;
import cn.schoolwow.quickdao.module.database.dcl.kit.DatabaseControl;
import cn.schoolwow.quickdao.module.database.dcl.service.CreateDatabaseUserAndGrantFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.CreateDatabaseUserFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.DeleteDatabaseUserFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.FlushPrivilegesFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.GetUserNameListFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.GrantFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.ModifyPasswordFlow;
import cn.schoolwow.quickdao.module.database.dcl.service.RevokeFlow;
import cn.schoolwow.quickdao.module.database.parent.kit.DatabaseDAOImpl;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class DatabaseControlImpl
extends DatabaseDAOImpl
implements DatabaseControl {
    public DatabaseControlImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }

    @Override
    public List<String> getUserNameList() {
        FlowContext flowContext = this.quickFlow.executeFlow(new BusinessFlow[]{new GetUserNameListFlow()});
        List userNameList = (List)flowContext.getData("userNameList");
        return userNameList;
    }

    @Override
    public boolean hasUserName(String username) {
        List<String> userNameList = this.getUserNameList();
        for (String username1 : userNameList) {
            if (!username1.equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) {
        this.quickFlow.startFlow((BusinessFlow)new CreateDatabaseUserFlow()).putReturnData("dataBaseUser", (Object)dataBaseUser, new FlowDataFeature[0]).execute();
    }

    @Override
    public void modifyPassword(String username, String newPassword) {
        this.quickFlow.startFlow((BusinessFlow)new ModifyPasswordFlow()).putReturnData("username", (Object)username, new FlowDataFeature[0]).putReturnData("newPassword", (Object)newPassword, new FlowDataFeature[0]).execute();
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) {
        this.quickFlow.startFlow((BusinessFlow)new DeleteDatabaseUserFlow()).putReturnData("dataBaseUser", (Object)dataBaseUser, new FlowDataFeature[0]).execute();
    }

    @Override
    public void grant(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new GrantFlow()).putReturnData("grantOption", (Object)grantOption, new FlowDataFeature[0]).execute();
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new CreateDatabaseUserAndGrantFlow()).putReturnData("grantOption", (Object)grantOption, new FlowDataFeature[0]).execute();
    }

    @Override
    public void revoke(GrantOption grantOption) {
        this.quickFlow.startFlow((BusinessFlow)new RevokeFlow()).putReturnData("grantOption", (Object)grantOption, new FlowDataFeature[0]).execute();
    }

    @Override
    public void flushPrivileges() {
        this.quickFlow.executeFlow(new BusinessFlow[]{new FlushPrivilegesFlow()});
    }
}

