/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.column;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.PropertyOption;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.GetEscapeCheckFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateTableColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new GetEscapeCheckFlow()});
        this.setStatement(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u65b0\u589e\u8868\u5b57\u6bb5";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        String tableName = (String)flowContext.checkData("tableName");
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                tableName = tableName.toUpperCase();
            }
        }
        PropertyOption propertyOption = (PropertyOption)flowContext.checkData("propertyOption");
        StringBuilder sqlBuilder = new StringBuilder("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " add ");
        flowContext.putTemporaryData("sqlBuilder", (Object)sqlBuilder);
        if (propertyOption.id && propertyOption.strategy == IdStrategy.AutoIncrement) {
            flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("propertyOption", (Object)propertyOption).execute();
        } else {
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + " " + propertyOption.columnType + (null == propertyOption.range ? "" : "(" + propertyOption.range + ")"));
            if (null != propertyOption.defaultValue && !propertyOption.defaultValue.isEmpty()) {
                sqlBuilder.append(" default " + propertyOption.defaultValue);
            }
            if (null != propertyOption.notNull && propertyOption.notNull.booleanValue()) {
                sqlBuilder.append(" not null");
            }
            if (flowContext.containKey("escapeCheck")) {
                sqlBuilder.append(" check " + flowContext.checkData("escapeCheck"));
            }
            if (null != propertyOption.comment) {
                switch (databaseType) {
                    case SQLite: {
                        break;
                    }
                    default: {
                        sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(propertyOption.comment));
                    }
                }
            }
        }
        sqlBuilder.append(";");
        switch (databaseType) {
            case Postgresql: {
                sqlBuilder.append("comment on column " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + "." + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + " is '" + propertyOption.comment + "';");
            }
        }
        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u65b0\u589e\u5217").execute();
    }
}

