/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.common;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.table.GetTableNameListFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.List;

public class GetDatabaseEntityFromCacheFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.getSpecificTableFromCache(flowContext);
        this.getAllTableFromCache(flowContext);
    }

    public String name() {
        return "\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f";
    }

    private void getSpecificTableFromCache(FlowContext flowContext) {
        String tableName = (String)flowContext.getData("tableName");
        if (null == tableName) {
            return;
        }
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        String columnName = (String)flowContext.getData("columnName");
        if (quickDAOConfig.databaseContext.databaseTableCache.containsKey(tableName)) {
            Entity entity = quickDAOConfig.databaseContext.databaseTableCache.get(tableName);
            if (null == columnName) {
                flowContext.putData("entity", (Object)entity, new FlowDataFeature[0]);
                flowContext.broken("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f");
            } else {
                Property property = entity.getPropertyByFieldNameOrColumnName(columnName);
                if (null != property) {
                    flowContext.putData("property", (Object)property, new FlowDataFeature[0]);
                    flowContext.broken("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6307\u5b9a\u8868\u7684\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f");
                }
                flowContext.brokenCurrentFlow("\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u6307\u5b9a\u8868\u7684\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f");
            }
        }
    }

    private void getAllTableFromCache(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        List tableNameList = (List)flowContext.executeFlowList(new BusinessFlow[]{new GetTableNameListFlow()}).getData("tableNameList");
        if (!tableNameList.isEmpty() && tableNameList.size() == quickDAOConfig.databaseContext.databaseTableCache.size()) {
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            entityList.addAll(quickDAOConfig.databaseContext.databaseTableCache.values());
            flowContext.putData("entityList", entityList, new FlowDataFeature[0]);
            flowContext.broken("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6240\u6709\u8868\u4fe1\u606f");
        }
    }
}

