/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.createTable;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.BuildForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;

public class MysqlCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.buildColumn(flowContext);
        this.buildIndex(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildForeignKeyFlow()});
        this.buildTableComment(flowContext);
    }

    public String name() {
        return "mysql\u6570\u636e\u5e93\u521b\u5efa\u8868";
    }

    private void buildColumn(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        StringBuilder sqlBuilder = new StringBuilder();
        flowContext.putTemporaryData("sqlBuilder", (Object)sqlBuilder);
        sqlBuilder.append("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("propertyOption", (Object)property).execute();
            } else {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.range ? "" : "(" + property.range + ")"));
                if (null != property.notNull && property.notNull.booleanValue()) {
                    sqlBuilder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    sqlBuilder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    sqlBuilder.append(" check " + property.escapeCheck);
                }
            }
            sqlBuilder.append(",");
        }
    }

    private void buildIndex(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        ArrayList<String> ignoreIndexNameList = new ArrayList<String>();
        for (IndexField indexField : entity.indexFieldList) {
            if (null == indexField.columns || indexField.columns.isEmpty()) {
                ignoreIndexNameList.add(indexField.indexName);
                continue;
            }
            switch (indexField.indexType) {
                case UNIQUE: {
                    sqlBuilder.append("unique");
                }
                case NORMAL: {
                    sqlBuilder.append(" index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.indexName) + " (");
                    for (String column : indexField.columns) {
                        sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(column) + ",");
                    }
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(")");
                    if (null != indexField.using && !indexField.using.isEmpty()) {
                        sqlBuilder.append(" using " + indexField.using);
                    }
                    if (null != indexField.comment && !indexField.comment.isEmpty()) {
                        sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(indexField.comment));
                    }
                    sqlBuilder.append(",");
                    break;
                }
                case FULLTEXT: {
                    sqlBuilder.append("fulltext(" + indexField.columns.get(0) + "),");
                }
            }
        }
        flowContext.putTemporaryData("ignoreIndexNameList", ignoreIndexNameList);
    }

    private void buildTableComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        if (!entity.properties.isEmpty()) {
            sqlBuilder.append(")");
        }
        if (null != entity.comment) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(entity.comment));
        }
        sqlBuilder.append(";");
    }
}

