/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.createTable;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.PostgresCreateTableFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.ExecuteCreateTableFlow;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;

public class OracleCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new PostgresCreateTableFlow(), new ExecuteCreateTableFlow()});
        this.createSequence(flowContext);
    }

    public String name() {
        return "Postgres\u6570\u636e\u5e93\u521b\u5efa\u8868";
    }

    private void createSequence(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final Entity entity = (Entity)flowContext.checkData("entity");
        if (null == entity.id) {
            return;
        }
        final StringBuilder createSequenceBuilder = new StringBuilder();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u5224\u65ad\u5e8f\u5217\u662f\u5426\u5b58\u5728").putTemporaryData("sql", (Object)("select sequence_name from user_sequences where sequence_name= '" + entity.tableName.toUpperCase() + "_SEQ'")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    createSequenceBuilder.append("drop sequence " + entity.tableName.toUpperCase() + "_SEQ;");
                }
            }
        }, new FlowDataFeature[0]).execute();
        createSequenceBuilder.append("create sequence " + entity.tableName + "_seq increment by 1 start with 1 minvalue 1 maxvalue 9999999999999 nocache order;");
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u521b\u5efa\u5e8f\u5217").putTemporaryData("sql", (Object)createSequenceBuilder.toString()).execute();
        String createTrigger = "create or replace trigger " + entity.tableName + "_trigger before insert on " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " for each row when(new.\"" + entity.id.column + "\" is null) begin select " + entity.tableName + "_seq.nextval into:new.\"" + entity.id.column + "\" from dual; end;";
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u521b\u5efa\u89e6\u53d1\u5668").putTemporaryData("sql", (Object)createTrigger).execute();
    }
}

