/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.createTable;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.BuildForeignKeyFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.createTable.common.BuildIndexFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SQLServerCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.buildColumn(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildForeignKeyFlow()});
        this.buildTableComment(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildIndexFlow()});
        this.buildComment(flowContext);
    }

    public String name() {
        return "Postgres\u6570\u636e\u5e93\u521b\u5efa\u8868";
    }

    private void buildColumn(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        StringBuilder sqlBuilder = new StringBuilder("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("propertyOption", (Object)property).execute();
            } else {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.range ? "" : "(" + property.range + ")"));
                if (null != property.notNull && property.notNull.booleanValue()) {
                    sqlBuilder.append(" not null");
                }
                if (null != property.defaultValue) {
                    sqlBuilder.append(" default '" + property.defaultValue + "'");
                }
                if (null != property.comment) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    sqlBuilder.append(" check " + property.escapeCheck);
                }
            }
            sqlBuilder.append(",");
        }
        flowContext.putTemporaryData("sqlBuilder", (Object)sqlBuilder);
    }

    private void buildTableComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        sqlBuilder.append(");");
    }

    private void buildComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        if (null != entity.comment) {
            sqlBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + entity.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "';");
        }
        for (Property property : entity.properties) {
            if (null == property.comment) continue;
            sqlBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + property.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "','column',N'" + property.column + "';");
        }
    }
}

