/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.index;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GetEntityIndexListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        flowContext.putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u7d22\u5f15\u4fe1\u606f");
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5b57\u6bb5\u4fe1\u606f";
    }

    private void getByH2(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, sql from information_schema.indexes where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "'")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        String sql = resultSet.getString("sql");
                        String[] tokens = sql.split("\"");
                        IndexField indexField = new IndexField();
                        indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.indexName = tokens[3];
                        indexField.tableName = tokens[7];
                        for (int i = 9; i < tokens.length - 1; ++i) {
                            indexField.columns.add(tokens[i]);
                        }
                        entity.indexFieldList.add(indexField);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getBySQLite(final FlowContext flowContext) {
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tbl_name, sql from sqlite_master where type='index' and sql is not null;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                ArrayList<String> warningSQLList = new ArrayList<String>();
                while (resultSet.next()) {
                    String tableName = resultSet.getString("tbl_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        String sql = resultSet.getString("sql");
                        if (!sql.contains("\"") && !sql.contains("`")) {
                            warningSQLList.add(sql);
                            continue;
                        }
                        String[] tokens = sql.split("[\"|`]");
                        IndexField indexField = new IndexField();
                        indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.indexName = tokens[1];
                        indexField.tableName = tokens[3];
                        for (int i = 5; i < tokens.length - 1; ++i) {
                            indexField.columns.add(tokens[i]);
                        }
                        entity.indexFieldList.add(indexField);
                    }
                }
                if (!warningSQLList.isEmpty()) {
                    flowContext.putTemporaryData("warningSQLList", warningSQLList);
                    flowContext.remark("\u5b58\u5728\u5f02\u5e38\u7d22\u5f15!\u7d22\u5f15\u4e0d\u5305\u542b\"\u4e5f\u4e0d\u5305\u542b`");
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getByMysql(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "';")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        String indexName = resultSet.getString("index_name");
                        if ("PRIMARY".equalsIgnoreCase(indexName)) {
                            for (Property property : entity.properties) {
                                if (!property.column.equals(resultSet.getString("column_name"))) continue;
                                property.id = true;
                            }
                            continue;
                        }
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        IndexField indexField = null;
                        for (IndexField indexField1 : entity.indexFieldList) {
                            if (!indexField1.indexName.equals(indexName)) continue;
                            indexField = indexField1;
                            break;
                        }
                        if (null == indexField) {
                            indexField = new IndexField();
                            indexField.tableName = tableName;
                            IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                            if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                                indexField.indexType = IndexType.FULLTEXT;
                            }
                            indexField.indexName = resultSet.getString("index_name");
                            indexField.using = resultSet.getString("index_type");
                            indexField.comment = resultSet.getString("index_comment");
                            entity.indexFieldList.add(indexField);
                        }
                        indexField.columns.add(resultSet.getString("column_name"));
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getByPostgres(FlowContext flowContext) {
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tablename,indexname,indexdef from pg_indexes;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("tablename");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        IndexField indexField = new IndexField();
                        indexField.tableName = resultSet.getString("tablename");
                        indexField.indexName = resultSet.getString("indexname");
                        String def = resultSet.getString("indexdef");
                        indexField.indexType = def.contains("UNIQUE INDEX") ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.using = def.substring(def.indexOf("USING") + "USING".length(), def.indexOf("(")).replace("\"", "");
                        String[] columns = def.substring(def.indexOf("(") + 1, def.indexOf(")")).split(",");
                        for (int i = 0; i < columns.length; ++i) {
                            indexField.columns.add(columns[i]);
                        }
                        entity.indexFieldList.add(indexField);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getBySQLServer(FlowContext flowContext) throws InterruptedException {
        List entityList = (List)flowContext.checkData("entityList");
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
        for (final Entity entity : entityList) {
            threadPoolExecutor.execute(() -> flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putThreadLocalData("sql", (Object)"select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id( ?, N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id(?, N'U' ) and i.index_id > 0;").putThreadLocalData("parameters", Arrays.asList(entity.tableName, entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

                @Override
                public void consumeResultSet(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        IndexField indexField = new IndexField();
                        indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.indexName = resultSet.getString("name");
                        IndexField existIndexField = entity.indexFieldList.stream().filter(indexField1 -> indexField1.indexName.equals(indexField.indexName)).findFirst().orElse(null);
                        if (null != existIndexField) {
                            existIndexField.columns.add(resultSet.getNString("col_name"));
                            continue;
                        }
                        indexField.columns.add(resultSet.getNString("col_name"));
                        entity.indexFieldList.add(indexField);
                    }
                }
            }, new FlowDataFeature[0]).execute());
        }
        threadPoolExecutor.shutdown();
        threadPoolExecutor.awaitTermination(3L, TimeUnit.MINUTES);
    }

    private void getByOracle(FlowContext flowContext) {
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select table_name, index_name,uniqueness from user_indexes").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        IndexField indexField = new IndexField();
                        indexField.tableName = tableName;
                        indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.indexName = resultSet.getString("index_name");
                        entity.indexFieldList.add(indexField);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name, index_name, column_name from user_ind_columns").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    String indexName = resultSet.getString("index_name");
                    String columnName = resultSet.getString("column_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        for (IndexField indexField : entity.indexFieldList) {
                            if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
                            indexField.columns.add(columnName);
                        }
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }
}

